package com.icetech.partner.api.request.open.rule;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * Description ChargeRuleSearchRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wg
 * @version 1.0 @Date 2022/7/15 17:50
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ChargeRuleSearchRequest implements Serializable {

    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号", required = true, example = "P100000", position = 1)
    private String parkCode;

    @NotNull(message = "计费规则类型不能为空")
    @ApiModelProperty(value = "计费规则类型，1、通用自然天 2、白天夜间收费 3、24小时计费；", required = true, example = "1", position = 2)
    private Integer billtype;

    @NotBlank(message = "计费规则编号不能为空")
    @ApiModelProperty(value = "计费规则编号 时间+随机数小于16位", example = "15151564613161161", required = true, position = 3)
    private String billtypecode;

}
