package com.icetech.partner.api.request.open.rule;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * Description ChargeRuleRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/24 7:02 下午
 */
@Data
public class ChargeRuleRequest<T> implements Serializable {

    @NotNull(message = "操作类型不能为空")
    @ApiModelProperty(value = "1=添加 2=修改 ", required = true, example = "1", position = 1)
    private Integer operType;

    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号", required = true, example = "P100000", position = 2)
    private String parkCode;

    @NotNull(message = "是否默认计费规则不能为空")
    @ApiModelProperty(value = "是否默认计费规则，0：否，1：是，车辆计费时使用默认计费规则；", required = true, example = "1", position = 3)
    private Integer isDefault;

    @NotBlank(message = "计费规则编号不能为空")
    @ApiModelProperty(value = "计费规则编号 时间+随机数小于16位", required = true, example = "1121314545", position = 4)
    private String billtypecode;

    @NotBlank(message = "计费规则名称不能为空")
    @ApiModelProperty(value = "计费规则名称", required = true, example = "计费规则1", position = 5)
    private String billtypename;

    @NotNull(message = "计费规则明细不能为空")
    @ApiModelProperty(value = "计费规则明细", required = true, example = "", position = 6)
    private T chargeRule;
}
