package com.icetech.partner.api.request.open.business;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * Description EditMonthCardRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/11 13:54
 */
@Data
public class EditMonthCardRequest implements Serializable {
    
    @NotNull(message = "月卡状态不能为空")
    @ApiModelProperty(value = "月卡状态（1：正常，2：禁用。）", required = true, example = "1", position = 1)
    private Integer cardStatus;

    @ApiModelProperty(value = "云平台月卡编号，此月卡的唯一标识", example = "1", position = 2)
    private String cardId;

    @NotBlank(message = "车场编码不能为空")
    @ApiModelProperty(value = "云平台停车场编码", required = true, example = "P100001", position = 3)
    private String parkCode;

    @NotNull(message = "套餐编号不能为空")
    @ApiModelProperty(value = "月卡套餐编号（通过月卡套餐查询接口获取）", required = true, example = "1000", position = 4)
    private Long productId;

    @NotBlank(message = "手机号不能为空")
    @ApiModelProperty(value = "手机号", required = true, example = "18500000000", position = 5)
    private String phone;

    @NotNull(message = "月卡申办性质不能为空")
    @ApiModelProperty(value = "月卡申办性质，详情查看数据定义部分", required = true, example = "1", position = 6)
    private Integer cardProperty;

    @NotBlank(message = "用户姓名/公司名称不能为空")
    @ApiModelProperty(value = "用户姓名/公司名称", required = true, example = "智芯原动", position = 7)
    private String cardOwner;

    @NotBlank(message = "车牌号不能为空")
    @ApiModelProperty(value = "车牌号,可以多个。会以”/“连接。比如车牌号信息：京JS7680/京JS7681/京JS7682/京JS7683/京JS7684/京JS7685", required = true, example = "京JS7680/京JS7681", position = 8)
    private String plateNum;

    @NotBlank(message = "开始日期不能为空")
    @ApiModelProperty(value = "月卡开始日期，格式为yyyy-MM-dd 如2017-07-01", required = true, example = "2017-07-01", position = 9)
    private String startDate;

    @NotBlank(message = "结束日期不能为空")
    @ApiModelProperty(value = "月卡结束日期，格式为yyyy-MM-dd 如2017-07-31", required = true, example = "2017-07-31", position = 10)
    private String endDate;

    @ApiModelProperty(value = "车位数量，默认为1，可支持多车位多车", example = "100", position = 11)
    private Integer plotCount;

    @ApiModelProperty(value = "车位号,可以多个。会以”/“连接。车位号的多少和车位数量保持一致，比如车位信息：A001 / A002/ A003", example = "A001 / A002/ A003", position = 12)
    private String plotNum;

    @ApiModelProperty(value = "金额，单位：元",  example = "100", position = 13)
    private String payMoney;

    @NotNull(message = "办理时间不能为空")
    @ApiModelProperty(value = "办理时间（unix时间戳秒)", required = true, example = "1495434452", position = 14)
    private Long operTime;

    @ApiModelProperty(value = "月卡范围 1=全车场 2=指定区域", example = "1", position = 15)
    private Integer mcRange;

    @ApiModelProperty(value = "月卡区域分区编号，mcRange=2时需指定办理的月卡的分区，分区编号从车场分区列表接口中获取 （场中场全车场需传regionCode=0）", example = "1", position = 16)
    private List<RegionData> regionData;
    
    @Data
    public static class RegionData implements Serializable {

        @ApiModelProperty(value = "区域编号", example = "1", position = 1)
        private String regionCode;
    }
}
