package com.icetech.partner.api.request.open.base;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author wanggang
 * @create 2022-07-15 14:28
 */
@Data
public class SaveParkSeniorInfoRequest implements Serializable {

    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "所属停车场编号", example = "P1515111", required = true, position = 1)
    private String parkCode;

    @ApiModelProperty(value = "剩余多少空车位时，禁止入场", required = false, example = "0", position = 2)
    private Integer fullEmptynum;

    @ApiModelProperty(value = "在车位满的情况下，是否禁止临时车入内，0：否 1：是， 默认为0’", required = false, example = "0", position = 3)
    private Integer isFullForbidenter;

    @ApiModelProperty(value = "在车位满的情况下，是否禁止月卡车入内", required = false, example = "1", position = 4)
    private Integer isFullForbidmonthenter;

    @ApiModelProperty(value = "在车位满的情况下，是否禁止VIP车入内，0：否 1：是", required = false, example = "1", position = 5)
    private Integer isFullForbidvipenter;

    @ApiModelProperty(value = "在车位满的情况下，是否禁止预约车入内，0：否 1：是", required = false, example = "1", position = 6)
    private Integer isFullForbidreserventer;

    @ApiModelProperty(value = "在车位满的情况下，是否禁止储值车入内，0：否 1：是", required = false, example = "1", position = 7)
    private Integer isFullForbidstoreenter;

    @ApiModelProperty(value = "月卡车是否计入总车位数1是 2 否 默认是2", example = "2", required = false, position = 8)
    private Integer isCardcount;

    @ApiModelProperty(value = "车辆出入口停留多长时间监控坐席提醒", required = false, example = "0", position = 9)
    private Integer carenexTimelong;

    @ApiModelProperty(value = "入场到出场最小时间值，以秒为单位，默认值是0，如果车辆出场时总停车时长小于x秒出场不进行任何处理", example = "0", required = false, position = 10)
    private Integer enexMinTime;

    @ApiModelProperty(value = "出场到入场最小时间值，以秒为单位，默认值是0，如果车辆入场时上次出场时间至当前时间时间差小于x秒入场不进行任何处理", example = "0", required = false, position = 11)
    private Integer exenMinTime;

    @ApiModelProperty(value = "显示终端类型，1：LED，2：LCD", example = "1", required = false, position = 12)
    private Integer displayTerminal;

    @ApiModelProperty(value = "控制卡型号 18：方控 19：科发 27：瑞泰科", example = "27", required = false, position = 13)
    private Integer ledcardType;

    @ApiModelProperty(value = "是否有TTS 0无,1有", example = "1", required = false, position = 14)
    private int ttsType;

    @ApiModelProperty(value = "计费精度 0：分钟，1：秒 默认0", example = "0", required = false, position = 15)
    private int billPrecision;

    @ApiModelProperty(value = "军警车是否免费停车 0：不免费 1：免费 默认1", example = "1", required = false, position = 16)
    private Integer isfreeSpecialcar;

    @ApiModelProperty(value = "AB车场内切换X时间不收费，单位分钟", example = "1", required = false, position = 17)
    private Integer switchTm;

    @ApiModelProperty(value = "支持多车位管理超时处理规则1：B车计费结束时间按A车出场时间收费 ，2：B车计费结束时间按B车出场时间收费 默认为1", example = "1", required = false, position = 18)
    private Integer switchType;

    @ApiModelProperty(value = "免费时间内是否自动抬杆 0：不自动 1：自动 默认为1", example = "1", required = false, position = 19)
    private Integer isreleaseFreetm;

    @ApiModelProperty(value = "免费时长是否计入停车费用1：是 2：否 默认为2", example = "2", required = false, position = 20)
    private Integer freetimeStatus;


    @ApiModelProperty(value = "是否补时 1是2否 默认为1", example = "1", required = false, position = 21)
    private Integer isFilltime;

    @ApiModelProperty(value = "超时计费起始时间1末次缴费时间 2车辆入场时间 默认为1", example = "1", required = false, position = 22)
    private Integer overtimeBillType;

    @ApiModelProperty(value = "是否允许二次使用免费时长 1不允许2允许 默认为1", example = "1", required = false, position = 23)
    private Integer isallowfreetmonce;

    @ApiModelProperty(value = "收费是否抹零头1是2否 默认为1", example = "1", required = false, position = 24)
    private Integer isnotgetsmallchange;

    @ApiModelProperty(value = "小型车无入场记录时的固定费用（单位元）", example = "2", required = false, position = 25)
    private Integer fixedfeevalue;

    @ApiModelProperty(value = "大型车无入场记录时的固定费用（单位元）", example = "2", required = false, position = 26)
    private Integer fixedFeeValueBig;

    @ApiModelProperty(value = "是否允许无牌车重复入场，0：否 1：是， 默认为0", example = "0", required = false, position = 27)
    private Integer isNoplateRepeatenter;

    @ApiModelProperty(value = "是否支持AB车管理 0：不支持 1：支持 默认0", example = "0", required = false, position = 28)
    private Integer issupAbmanage;

    @ApiModelProperty(value = "出场查无入场记录、支持固定收费1是2否 默认为2", example = "2", required = false, position = 29)
    private Integer isfixedfees;

    @ApiModelProperty(value = "是否特殊车场（存在进出共用一个通道的车场）0不是，1是 默认是0", example = "0", required = false, position = 30)
    private Integer isSpecialPark;

}
