package com.icetech.partner.api.request.open.base;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * Description SaveParkRequest
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/7/14 09:45
 */
@Data
public class SaveParkRequest implements Serializable {

    @ApiModelProperty(value = "停车场编号，新增车场时，不传此值", example = "P1515111", position = 1)
    private String parkCode;

    @NotBlank(message = "停车场名称不能为空")
    @ApiModelProperty(value = "停车场名称", required = true, example = "停车场1", position = 2)
    private String parkName;

    @ApiModelProperty(value = "联系电话", example = "13888888888", position = 3)
    private String phone;

    @NotNull(message = "省级区域ID不能为空")
    @ApiModelProperty(value = "省级区域ID", required = true, example = "3", position = 4)
    private Integer provinceId;

    /**
     * 车场所属城市
     */
    @NotNull(message = "城市ID不能为空")
    @ApiModelProperty(value = "城市ID", required = true, example = "3", position = 5)
    private Integer cityId;

    /**
     * 所属区域
     */
    @NotNull(message = "城区ID不能为空")
    @ApiModelProperty(value = "城区ID", required = true, example = "3", position = 6)
    private Integer districtId;

    /**
     * 总车位数
     */
    @NotNull(message = "停车场总车位数不能为空")
    @ApiModelProperty(value = "停车场总车位数", required = true, example = "100", position = 7)
    private Integer totalNum;

    /**
     * 车场地址
     */
    @ApiModelProperty(value = "停车场地址", example = "北辰世纪中心", position = 8)
    private String address;

    @NotNull(message = "车场类型不能为空")
    @ApiModelProperty(value = "车场类型，1：端云 2：端网云", required = true, example = "1", position = 9)
    private Integer dataCollection;

    /**
     *停车场属性
     */
    @ApiModelProperty(value = "停车场属性 0：其他 1：商超 2：商务写字楼 3：公共场馆 4 星级酒店 5：住宅 6：医院 7：学校 8：交通枢纽 9：商业综合体 10产业园 11路侧", example = "5", position = 10)
    private Integer parkProperty = 5;

    /**
     * 车场经度
     */
    @ApiModelProperty(value = "停车场纬度", example = "137.666", position = 11)
    private String lat;
    
    /**
     * 车场纬度
     */
    @ApiModelProperty(value = "停车场经度", example = "122.788", position = 12)
    private String lng;

    @ApiModelProperty(value = "空位数", example = "100", position = 13)
    private Integer freeSpace;

    @ApiModelProperty(value = "车场类型（0:室内、1：室外、2：室内+室外、3：占道 默认：0", example = "1", position = 14)
    private int parkType;

    /**
     * 是否存在场中场(0否，1是默认0)
     */
    @ApiModelProperty(value = "是否存在场中场(0否，1是默认0) ，暂不支持场中场", example = "10", position = 15)
    private int isInterior;

    /**
     * 场中场切换免费时长 分钟
     */
    @ApiModelProperty(value = "场中场切换免费时长", example = "100", position = 16)
    private Integer switchFeeTime;

    @ApiModelProperty(value = "资产类型(1产权、2管理权、3经营权默认0)", example = "1", position = 17)
    private Integer assetType;

    /**
     *入口数量
     */
    @ApiModelProperty(value = "入口数量", example = "10", position = 18)
    private Integer totalEnter;

    /**
     *出口数量
     */
    @ApiModelProperty(value = "出口数量", example = "10", position = 19)
    private Integer totalExit;

    @ApiModelProperty(value = "合作方式(1自营、2合作、3加盟默认0)", example = "1", position = 20)
    private Integer cooperateType;

}
