package com.icetech.partner.api.request.open;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Setter
@Getter
@ToString
public class ThirdFeeRequest implements Serializable {
    /**
     *
     * 车场编码
     */
    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号，由平台统一分配", example = "P100122", required = true, position = 1)
    private String parkCode;
    /**
     * 车牌号
     */
    @NotBlank(message = "车牌号不能为空")
    @ApiModelProperty(value = "车牌号", example = "京A88888", required = true, position = 2)
    private String plateNum;
    /**
     * 订单号
     */
    @NotBlank(message = "订单号不能为空")
    @ApiModelProperty(value = "订单号", example = "2022072688888", required = true, position = 3)
    private String orderNum;
    /**
     * 通道编号
     */
    @NotBlank(message = "通道编号不能为空")
    @ApiModelProperty(value = "通道编号", example = "C22072688888", required = true, position = 4)
    private String channelCode;
    /**
     * 入场时间
     */
    @ApiModelProperty(value = "入场时间[unix时间戳秒]", example = "1658824199", required = true, position = 5)
    private Long enterTime;
    /**
     * 出场识别时间
     */
    @NotBlank(message = "出场识别时间[unix时间戳秒]")
    @ApiModelProperty(value = "出场识别时间", example = "1658824199", required = true, position = 6)
    private Long exitTime;
    /**
     * 车辆类型
     */
    @ApiModelProperty(value = "车型，1：小型车，2：大型车", example = "1", required = true, position = 7)
    private Integer carType;
    /**
     * 停车时长
     */
    @ApiModelProperty(value = "停车时长（秒）", example = "60", required = true, position = 8)
    private Integer parkTime;

}
