package com.icetech.partner.api.request.open;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author fangct
 */
@Data
public class RegionListRequest implements Serializable {

    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号（系统自动生成）", example = "P100122", required = true, position = 1)
    private String parkCode;

    @ApiModelProperty(value = "分页查询页码（默认1,每页10条）", example = "1", position = 2)
    private Integer pageNo;

    @ApiModelProperty(value = "分页查询单页数量（默认20 小于1000）", example = "2", position = 3)
    private Integer pageSize;

}
