package com.icetech.partner.api.request.open;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhangpengzhan
 * @date 2021/6/16 15:42
 * @description:
 */
@Data
public class ParkDeviceResponse implements Serializable {

    @ApiModelProperty(value = "所属停车场编号", required = true, example = "P151511", position = 1)
    private String parkCode;

    @ApiModelProperty(value = "所属停车场名称", required = true, example = "tet11", position = 2)
    private String parkName;

    @ApiModelProperty(value = "通道编号", required = true, example = "001", position = 3)
    private String channelCode;

    @ApiModelProperty(value = "通道名称", required = true, example = "出1", position = 4)
    private String channelName;

    @ApiModelProperty(value = "设备序列号（type=5时非必填，机器人无序列号）", required = true, example = "111111", position = 5)
    private String serialNumber;

    @ApiModelProperty(value = "设备运行状态（0未连接，1在线，2离线）（监控相机和对讲立柱非必填）", required = false, example = "1", position = 6)
    private Integer deviceStatus;

    @ApiModelProperty(value = "设备编号", required = false, example = "1111", position = 7)
    private String deviceNo;

    @ApiModelProperty(value = "协议类型", required = false, example = "", position = 8)
    private Integer protocolType;

    @ApiModelProperty(value = "设备类型，1：摄像头 4：语音对接 5：智能机器人 6：监控相机", required = true, example = "1", position = 9)
    private Integer type;

    @ApiModelProperty(value = "最后通讯时间，单位秒（deviceStatus=0时非必填，未连接的无通讯时间）", required = true, example = "100000", position = 10)
    private Date endConTime;
}
