package com.icetech.partner.api.request.open;

import com.icetech.common.annotation.NotNull;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author wanggang
 * @create 2021-08-26 9:46
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Builder
public class DeleteParkRequestDTO implements Serializable {

    @NotBlank(message = "停车场编号不能为空")
    @ApiModelProperty(value = "停车场编号", example = "P100122", required = true, position = 1)
    private String parkCode;
}
