package com.icetech.partner.api.request.open;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2021-07-22 19:34
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class ChannelUrls implements Serializable {

    @ApiModelProperty(value = "通道编号", required = true, example = "C111111", position = 1)
    private String channelCode;

    @ApiModelProperty(value = "出入口类型，1：入口，2：出口", required = true, example = "1", position = 2)
    private Integer gateType;

    @ApiModelProperty(value = "二维码URL", required = true, example = "http://ice.car.com", position = 3)
    private String qrcodeUrl;
}
