package com.icetech.partner.api.request;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Objects;

/**
 * 青岛城投入场请求
 * @author wangzhiwei
 */
@Data
public class QingdaoCtEnterRequest implements Serializable {
    private String barrier_park_id;
    private String barrier_gateway_id;
    private String third_order_no;
    private Integer entrance_type;
    private String plate_no;
    /**
     * eg 2021/07/11 20:34:50
     */
    private String entrance_time;
    private Integer plate_color;
    private Integer car_type;
    private String car_brand;
    private String car_color;
    private Integer entrance_mode;

    /**
     * 车牌颜色: 1-蓝,2- 黄,3- 黑,4- 白,5-绿
     * @param color
     * @return
     */
    public static Integer switchColor(String color){
        if (StringUtils.isEmpty(color)){
            return 1;
        }
        if ("蓝色".equals(color)){
            return 1;
        }

        if ("黄色".equals(color)){
            return 2;
        }
        if ("黑色".equals(color)){
            return 3;
        }
        if ("白色".equals(color)){
            return 4;
        }
        if ("绿色".equals(color)){
            return 5;
        }
        //默认
        return 1;
    }

    /**
     * 车辆类型: 1-大巴车,2-中巴 车,3-私家 车
     * @param carType
     * @return
     */
    public static Integer switchCarType(Integer carType){
        if (Objects.isNull(carType)){
            return 3;
        }
        if (1 == carType){
           return  3;
        }
        if (2 == carType){
            return  1;
        }
        //默认
        return 3;
    }

}
