package com.icetech.partner.api;

import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.third.domain.entity.third.ThirdInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zhangpengzhan
 * @date 2021/4/2 11:17
 * @description:上海市政平台对接
 */
public interface ShanghaiCloudService {

    /**
     * 心跳服务接口，每五分钟一次
     * @return
     */
    ObjectResponse<String> upHeartbeat(String url, Long parkId, Map<String,Object> stringObjectMap);

    /**
     * 定时任务
     * @return
     */
    ObjectResponse<String> timerCycle();
    ObjectResponse<String> timerCycleHeartbeat();
    ObjectResponse<String>  timerCycleDownReserves();
    ObjectResponse<String>  timerCycleDownStagger();
    ObjectResponse downReduces(QueryOrderFeeRequest queryOrderFeeRequest,Map<String, Object> stringObjectMap );
    ObjectResponse<String> downReserves(String url, Long parkId, Map<String,Object> mapObject);
    HashMap<String,Object> getFeeService(String params);
    ObjectResponse<Boolean>  payMent(CarExitRequest carExitRequest, QueryOrderFeeResponse queryOrderFeeResponse);
    Map<String, Object> notifyPay(String param);
    ObjectResponse<Void> downStagger(String url,Long parkId ,Map<String,Object> objectMap);
    ObjectResponse downPayResult(Long payDate,String parkCode);
    HashMap<String,Object> getInvoce(String params);
    ObjectResponse getBillInfos(String parkCode,Long billDate);
    ObjectResponse notifyPathUrl(ThirdInfo thirdInfo, Long parkId);
    ObjectResponse getParams(String parkCode);
    ObjectResponse queryPayResult(OrderPay orderPay );
}
