package com.icetech.partner.api;

import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.partner.domain.request.luogang.PaidNotifyRequest;
import com.icetech.partner.api.request.luogang.PayUrlRequest;
import com.icetech.partner.api.request.luogang.OpenGateRequest;
import com.icetech.partner.domain.request.luogang.PushOrderInfoRequest;
import com.icetech.partner.domain.request.luogang.SaveDeviceInfoRequest;
import com.icetech.partner.domain.request.luogang.SaveInVehicleRecordRequest;
import com.icetech.partner.domain.request.luogang.SaveOutVehicleRecordRequest;
import com.icetech.partner.domain.request.luogang.UpdateDeviceInfoRequest;
import com.icetech.partner.domain.response.luogang.Response;

import java.util.Map;

/**
 * 骆岗平台对接
 * @author fangct
 */
public interface LuoGangService {
    ObjectResponse<Park> checkPark(String parkCode);

    /**
     * 开闸接口
     * @return 成功/失败
     */
    Response<Void> openGate(OpenGateRequest openGateRequest);

    /**
     * 开闸接口
     * @return 成功/失败
     */
    ObjectResponse<Map<String, Object>> getPayUrl(PayUrlRequest payUrlRequest);

    /**
     * 拉取月卡列表，每五分钟一次
     * @return 成功/失败
     */
    ObjectResponse<Void> monthlyCarInfoList();

    /**
     * 拉取黑名单车辆，每五分钟一次
     * @return 成功/失败
     */
    ObjectResponse<Void> blackCarInfoList();

    ObjectResponse<Void> payNotify(PaidNotifyRequest request);

    ObjectResponse<Void> saveInVehicleRecord(SaveInVehicleRecordRequest request);
    ObjectResponse<Void> saveOutVehicleRecord(SaveOutVehicleRecordRequest request);
    ObjectResponse<Void> pushOrderInfo(PushOrderInfoRequest request);
    ObjectResponse<Void> saveDeviceInfo(SaveDeviceInfoRequest request);
    ObjectResponse<Void> updateDeviceInfo(UpdateDeviceInfoRequest request);
}
