package com.icetech.partner.api;

import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.open.domain.ApiBaseRequest;

import java.util.LinkedHashMap;

/**
 * 对外开放接口
 * @author fangct
 */
public interface IOpenApiService {

    /**
     * 执行业务
     * @param apiBaseRequest
     * @return
     */
    ObjectResponse<Object> request(ApiBaseRequest<LinkedHashMap<String, Object>> apiBaseRequest);

    /**
     * 用于内部直接请求开放接口
     * @param request 请求参数
     *                必要参数：{@link ApiBaseRequest#getServiceName()} {@link ApiBaseRequest#getBizContent()}
     * @see com.icetech.partner.service.pull.RequestService#innerRequest(ApiBaseRequest)
     */
    <T, R> ObjectResponse<R> innerRequest(ApiBaseRequest<T> request);

    /**
     * 执行业务
     * @param param         参数对象            
     * @param serviceName   服务名称
     * @return R
     */
    
    <R, T> R request(T param, String serviceName);
}
