package com.icetech.partner.api;

import com.icetech.open.domain.request.fenmiao.ParkingRequest;
import com.icetech.open.domain.response.fenmiao.FmResponse;

/**
 * 外部请求接口-分秒云
 * @author fangct
 */
public interface IFmCloudService {
    /**
     * 无牌车入场
     * @param request
     * @return
     */
    FmResponse noplateEnter(ParkingRequest request);

    /**
     * 请求算费
     * @param request
     * @return
     */
    FmResponse queryFee(ParkingRequest request);

    /**
     * 支付结果下发
     * @param request
     * @return
     */
    FmResponse payResult(ParkingRequest request);

    /**
     * 白名单下发
     * @param request
     * @return
     */
    FmResponse releasewhite(ParkingRequest request);
    /**
     * 白名单删除
     * @param request
     * @return
     */
    FmResponse deletewhite(ParkingRequest request);
    /**
     * 黑名单下发
     * @param request
     * @return
     */
    FmResponse releaseblack(ParkingRequest request);
    /**
     * 黑名单下发
     * @param request
     * @return
     */
    FmResponse delblack(ParkingRequest request);
    /**
     * 控制停车场车道道闸
     * @param request
     * @return
     */
    FmResponse switchgate(ParkingRequest request);
    /**
     * 下发优惠券
     * @param request
     * @return
     */
    FmResponse releasediscount(ParkingRequest request);
    /**
     * 获取当前通道信息
     * @param request
     * @return
     */
    FmResponse getPassageWayInfo(ParkingRequest request);
}
