package com.icetech.user.service.impl;

import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.park.SaasUserParkService;
import com.icetech.cloudcenter.api.user.UserService;
import com.icetech.common.constants.CodeConstants;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.user.dao.MpUserDao;
import com.icetech.user.dao.SaasUserDao;
import com.icetech.user.dao.UserDefultAisleDao;
import com.icetech.user.domain.entity.user.*;
import com.icetech.cloudcenter.domain.response.SaasUserDto;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.user.domain.vo.SaasCsUserVo;
import com.icetech.user.service.SaasInstitutionService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.util.*;
import java.util.stream.Collectors;

import static com.icetech.cloudcenter.domain.response.SaasUserDto.isModify;

/**
 * 用户服务实现类
 * @author wangzw
 */
@Slf4j
@Service("userService")
public class UserServiceImpl implements UserService {
    private static final String ROLE_NAME1 = "云岗亭管理员";
    private static final String ROLE_NAME2 = "中央收费员";
    private static final String ROLE_NAME3 = "智慧停车云坐席";
    private static final String ROLE_NAME4 = "云调试助手";
    private static final String ROLE_NAME5 = "系统管理员";
    private static final String ROLE_NAME6 = "车场管理员";
    private static final String ROLE_NAME7 = "岗亭收费员";
    // 必须是 16 字节
    public static final String SECRET_KEY = "ZocNQD0mdfcmMKEWmtISpQ==";
    // AES CBC 模式需要 16 字节的 IV
    public static final String INIT_VECTOR = "Aocade0xxermMKEW";

    /**
     * 正则
     */
    public static final String REGEX = "^(?=.*[a-zA-Z])(?=.*\\d).{8,16}$";

    public static final String SALT = "guokong";
    @Autowired
    private SaasUserDao saasUserDao;
    @Autowired
    private MpUserDao mpUserDao;
    @Autowired
    private UserDefultAisleDao userDefultAisleDao;
    @Autowired
    private ParkService parkService;
    @Autowired
    private SaasInstitutionService saasInstitutionService;
    @Autowired
    private SaasUserParkService saasUserParkService;
    @Override
    public ObjectResponse<SaasUserDto> carManagerLogin(String userName, String password, String newPwd, Integer from) {
        try {
            SaasUser saasUser = saasUserDao.selectByUserName(userName);
            if (Objects.isNull(saasUser)|| !saasUser.getUsername().equals(userName)){
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_404.getCode(),"用户不存在");
            }
            SaasUserDto saasUserDto = new SaasUserDto();
            BeanUtils.copyProperties(saasUser, saasUserDto);
            saasUserDto.setUpdateFlag(0);
            saasUserDto.setFrom(from);
            if (!StringUtils.isBlank(newPwd)) {
                String decryptPwd = decrypt(newPwd);
                if (StringUtils.isEmpty(decryptPwd)) {
                    return ObjectResponse.failed("1000","密码错误");
                }
                if (decryptPwd.length() < 8 || decryptPwd.length() > 16 || !decryptPwd.matches(REGEX)) {
                    saasUserDto.setUpdateFlag(1);
                }
                //验证密码的正确性
                if (!DigestUtils.md5Hex(decryptPwd + SALT).equalsIgnoreCase(saasUser.getPassword())){
                    return ObjectResponse.failed("1000","用户名或密码错误");
                }
            }else {
                //验证密码的正确性
                if (!DigestUtils.md5Hex(password + SALT).equalsIgnoreCase(saasUser.getPassword())){
                    return ObjectResponse.failed("1000","用户名或密码错误");
                }
            }
            String roleName = saasUserDao.getRoleName(saasUser.getRoleId());
            saasUserDto.setRoleName(roleName);
            //from 2：云岗亭小程序，3：中央收费站，4：远程监控客服坐席，5：本地坐席，6：APP，7海大小程序 默认为2
            if (from == null || from == 2){
                List<String> permitRoleNames = Arrays.asList(ROLE_NAME1, ROLE_NAME4, ROLE_NAME6);
                if (!permitRoleNames.contains(roleName)){
                    return ObjectResponse.failed(CodeConstantsEnum.ERROR_401.getCode(),"当前角色不允许登陆");
                }
                if (roleName.equals(ROLE_NAME1)){
                    saasUserDto.setFrom(2);
                }
                if (roleName.equals(ROLE_NAME4)){
                    saasUserDto.setFrom(5);
                }
            }else if (from == 3){
                if (StringUtils.isEmpty(roleName) || !roleName.equals(ROLE_NAME2)){
                    return ObjectResponse.failed(CodeConstantsEnum.ERROR_401.getCode(),"当前角色不允许登陆");
                }
            }else if(from == 4){
                if (StringUtils.isEmpty(roleName) || !roleName.equals(ROLE_NAME3)){
                    return ObjectResponse.failed(CodeConstantsEnum.ERROR_401.getCode(),"当前角色不允许登陆");
                }
                UserDefultAisle userDefultAisle = userDefultAisleDao.selectByUserId(saasUser.getId());
                saasUserDto.setIsDefault(2);
                if(!Objects.isNull(userDefultAisle)){
                    if(StringUtils.isNotEmpty(userDefultAisle.getAisleCode())){
                        saasUserDto.setIsDefault(1);
                    }
                }
            }else if(from == 5){
                List<String> permitRoleNames = Arrays.asList(ROLE_NAME6, ROLE_NAME7);
                if (!permitRoleNames.contains(roleName)){
                    return ObjectResponse.failed(CodeConstantsEnum.ERROR_401.getCode(),"当前角色不允许登陆");
                }
            } else if (from == 6) {
                List<String> permitRoleNames = Arrays.asList(ROLE_NAME1, ROLE_NAME5, ROLE_NAME6,
                        SaasUserDto.RoleEnum.ROLE_NAME7.getRoleName());
                if (!permitRoleNames.contains(roleName)){
                    return ObjectResponse.failed(CodeConstantsEnum.ERROR_401.getCode(),"当前角色不允许登陆");
                }
            }
            if (from != null && (from == 2 || from == 5 || from == 6)) {
                if (roleName.equals(ROLE_NAME6)) {
                    boolean allowLogin = parkManagerLoginValidate(saasUser.getLoginPortType(), from);
                    if (!allowLogin) {
                        return ObjectResponse.failed(CodeConstants.ERROR_401, "当前角色不允许登陆");
                    }
                }
            }
            return ObjectResponse.success(saasUserDto);
        }catch (Exception e){
            log.error("[车场管家登陆接口异常],{}",e.getMessage());
            return ObjectResponse.failed(CodeConstantsEnum.ERROR.getCode(),CodeConstantsEnum.ERROR.getDesc());
        }
    }

    @Override
    public ObjectResponse<SaasUserDto> carManagerLogin(String userName, String password) {
        return carManagerLogin(userName, password, "1xxxxxxxxx", 2);
    }

    @Override
    public ObjectResponse updatePassWord(Integer userId, String oldPwd, String newPwd, String updateOldPwd, String updateNewPwd) {
        try {
            SaasUser saasUser = saasUserDao.load(userId);
            if (Objects.isNull(saasUser)){
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_404.getCode(),"用户不存在");
            }
            if (StringUtils.isNotBlank(updateOldPwd) && StringUtils.isNotBlank(updateNewPwd)) {
                String decryptPwd = decrypt(updateOldPwd);
                if (StringUtils.isEmpty(decryptPwd)) {
                    return ObjectResponse.failed("1000","密码错误");
                }
                //校验旧密码的正确
                if (!DigestUtils.md5Hex(decryptPwd+SALT).equalsIgnoreCase(saasUser.getPassword())){
                    return ObjectResponse.failed("1000","用户名或密码错误");
                }
                String decryptNewPwd = decrypt(updateNewPwd);
                if (StringUtils.isEmpty(decryptNewPwd)) {
                    return ObjectResponse.failed("1000","密码错误");
                }
                if (decryptNewPwd.length() < 8 || decryptNewPwd.length() > 16) {
                    return ObjectResponse.failed("1000","请输入8-16位密码");
                }
                boolean flag = decryptNewPwd.matches(REGEX);
                if (!flag) {
                    return ObjectResponse.failed("1000","密码需包含字母和数字，长度在8-16之间");
                }
                //修改新密码
                saasUser.setPassword(DigestUtils.md5Hex(decryptNewPwd+SALT));
            }else {
                //校验旧密码的正确
                if (!DigestUtils.md5Hex(oldPwd+SALT).equalsIgnoreCase(saasUser.getPassword())){
                    return ObjectResponse.failed(CodeConstantsEnum.ERROR_402.getCode(),"用户名或密码错误");
                }
                //修改新密码
                saasUser.setPassword(DigestUtils.md5Hex(newPwd+SALT));
            }
            saasUserDao.update(saasUser);
            return ObjectResponse.success();
        }catch (Exception e){
            log.error("[车场管家修改密码接口异常],{}",e.getMessage());
            return ObjectResponse.failed(CodeConstantsEnum.ERROR.getCode(),CodeConstantsEnum.ERROR.getDesc());
        }
    }

    @Override
    public ObjectResponse updatePassWord(Integer userId, String newPwd) {
        try {
            SaasUser saasUser = saasUserDao.load(userId);
            if (Objects.isNull(saasUser)){
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_404.getCode(),"用户不存在");
            }
            //修改新密码
            saasUser.setPassword(DigestUtils.md5Hex(newPwd+SALT));
            saasUserDao.update(saasUser);
            return ObjectResponse.success();
        }catch (Exception e){
            log.error("[车主端重置密码接口异常],{}",e.getMessage());
            return ObjectResponse.failed(CodeConstantsEnum.ERROR.getCode(),CodeConstantsEnum.ERROR.getDesc());
        }
    }

    /**
     * 车场管理员是否可以登录from系统
     *
     * @param loginPortType 登录端口 1：车场管理平台 2：车场帮APP:3：车场监控:4：知位岗亭小程序 默认全部
     * @param from 2：知位岗亭小程序，5：车场监控，6：车场帮APP
     * @return
     */
    @Override
    public boolean parkManagerLoginValidate(String loginPortType, Integer from){
        if (StringUtils.isBlank(loginPortType)) {
            return false;
        }
        List<String> loginPortTypeList = Arrays.asList(loginPortType.split(","));
        boolean allowLogin = false;
        switch (from) {
            case 2:
                if (loginPortTypeList.contains(String.valueOf(4))) {
                    allowLogin = true;
                }
                break;
            case 5:
                if (loginPortTypeList.contains(String.valueOf(3))) {
                    allowLogin = true;
                }
                break;
            case 6:
                if (loginPortTypeList.contains(String.valueOf(2))) {
                    allowLogin = true;
                }
                break;
            default:
                break;
        }
        return allowLogin;
    }

    @Override
    public ObjectResponse<SaasUserDto> getUserDetail(Integer userId) {
        SaasUser saasUser = saasUserDao.load(userId);
        if (Objects.isNull(saasUser)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404.getCode(),"用户不存在");
        }
        SaasUserDto saasUserDto = new SaasUserDto();
        BeanUtils.copyProperties(saasUser, saasUserDto);
        saasUserDto.setImgUrl("https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1556084581720&di=5133ea34ece400be9f5b69341fb0d945&imgtype=0&src=http%3A%2F%2Fimg.zcool.cn%2Fcommunity%2F01786557e4a6fa0000018c1bf080ca.png");
        return ObjectResponse.success(saasUserDto);
    }

    @Override
    public ObjectResponse<MpUser> mpLogin(String mobile, String openId) {
        MpUser mpUser = null;
        if (StringUtils.isNotEmpty(mobile)){
            mpUser = mpUserDao.selectByMobile(mobile,null,null);
        }
        if (Objects.isNull(mpUser)){
            mpUser = mpUserDao.selectByMobile(null,openId,null);
        }
        if (Objects.isNull(mpUser)){
            mpUser = new MpUser();
            mpUser.setMobile(mobile);
            mpUser.setOpenId(openId);
            mpUser.setCreateTime(new Date());
            mpUserDao.insert(mpUser);
        }else {
            //更新
            mpUser.setUpdateTime(new Date());
            mpUser.setMobile(mobile);
            mpUser.setOpenId(openId);
            mpUserDao.update(mpUser);
        }
        return ObjectResponse.success(mpUser);
    }


    @Override
    public ObjectResponse<MpUser> mpLogin(String mobile, String openId,String miniOpenId) {
        MpUser mpUser;
        if (StringUtils.isNotBlank(mobile)) {
            mpUser = mpUserDao.selectByMobile(mobile, null, null);
        } else {
            mpUser = mpUserDao.selectByMobile(mobile,openId,miniOpenId);
        }
        if (Objects.isNull(mpUser)){
            mpUser = new MpUser();
            mpUser.setMobile(mobile);
            mpUser.setOpenId(openId);
            mpUser.setMiniOpenId(miniOpenId);
            mpUser.setCreateTime(new Date());
            mpUserDao.insert(mpUser);
        }else {
            //更新
            mpUser.setUpdateTime(new Date());
            if(StrUtil.isNotBlank(mobile)){
                mpUser.setMobile(mobile);
            }
            if(StrUtil.isNotBlank(openId)){
                mpUser.setOpenId(openId);
            }
            if(StrUtil.isNotBlank(miniOpenId)){
                mpUser.setMiniOpenId(miniOpenId);
            }
            mpUserDao.update(mpUser);
        }
        return ObjectResponse.success(mpUser);
    }

    @Override
    public ObjectResponse<List<String>> getMpUserBindPlateNum(Integer id) {

        List<String> plateNums = mpUserDao.selectPlateNumByUserId(id);
        if (CollectionUtils.isEmpty(plateNums)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(plateNums);
    }



    @Override
    public ObjectResponse addMpUserBindPlateNum(Integer mpUserId, String plateNum) {
        //查看当前车牌是否绑定
        Integer count = mpUserDao.verifyPlateNum(plateNum);
        if (count>0) return ObjectResponse.failed(CodeConstantsEnum.ERROR_402.getCode(),"车牌已经被绑定");
        MpUserPlate mpUserPlate = new MpUserPlate();
        mpUserPlate.setMpUserId(mpUserId);
        mpUserPlate.setPlateNum(plateNum);

        //添加绑定车牌
        mpUserDao.insertBind(mpUserPlate);
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse deleteMpUserBindPlateNum(Integer mpUserId, String plateNum) {
        //添加绑定车牌
        mpUserDao.deleteBind(mpUserId,plateNum);
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<SaasUserDto> getUserByName(String userName) {
        SaasUser saasUser = saasUserDao.selectByUserName(userName);
        if (Objects.isNull(saasUser)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404.getCode(),"用户不存在");
        }
        String roleName = saasUserDao.getRoleName(saasUser.getRoleId());
        if(!isModify(roleName)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404.getCode(),"用户不存在");
        }
        SaasUserDto saasUserDto = new SaasUserDto();
        BeanUtils.copyProperties(saasUser, saasUserDto);
        return ObjectResponse.success(saasUserDto);
    }

    @Override
    public ObjectResponse<SaasUserDto> getUserByUserName(String userName) {
        SaasUser saasUser = saasUserDao.selectUserName(userName);
        if (Objects.isNull(saasUser)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404.getCode(),"用户不存在");
        }
        SaasUserDto saasUserDto = new SaasUserDto();
        BeanUtils.copyProperties(saasUser, saasUserDto);
        return ObjectResponse.success(saasUserDto);
    }

    @Override
    public ObjectResponse<MpUser> getMpUserByPlateNum(String plateNum) {
        MpUser mpUser = mpUserDao.selectOpenIdByPlateNum(plateNum);
        return ObjectResponse.returnNotFoundIfNull(mpUser);
    }

    @Override
    public ObjectResponse<SaasUser> getSaasUserBySeatNum(String seatNumber) {
        return ObjectResponse.returnNotFoundIfNull(saasUserDao.selectBySeatNum(seatNumber));
    }

    @Override
    public ObjectResponse<List<SaasUser>> getSaasUserByIds(List<Long> userIds) {
        return ObjectResponse.success(saasUserDao.selectByIds(userIds));
    }

    @Override
    public ObjectResponse<List<SaasUser>> getSaasCsUserByIds(List<Long> userIds) {
        return null;
    }

    @Override
    public ObjectResponse<List<SaasCsUserVo>> getCsUserByPark(String parkCode) {
        ObjectResponse<Park> byParkCode = parkService.findByParkCode(parkCode);
        SaasInstitution saasInstitution = saasInstitutionService.getSaasInstitutionById(byParkCode.getData().getInstitutionId().longValue());
        Set<Integer> userIds = Sets.newHashSet();
        if (Objects.nonNull(saasInstitution)) {
            List<Integer> institutionIds = Arrays.stream(saasInstitution.getCode().split(",")).filter(StringUtils::isNotBlank).map(Integer::parseInt).collect(Collectors.toList());
            List<SaasUserPark> saasUserParkByInstitutionIds = saasUserParkService.getSaasUserParkByInstitutionIds(institutionIds);
            if (CollectionUtils.isNotEmpty(saasUserParkByInstitutionIds)) {
                saasUserParkByInstitutionIds.forEach(saasUserPark -> userIds.add(saasUserPark.getUserId()));
            }
            List<SaasUserPark> saasUserParks = saasUserParkService.listByParkId(byParkCode.getData().getId());
            if (CollectionUtils.isNotEmpty(saasUserParks)) {
                saasUserParks.forEach(saasUserPark -> userIds.add(saasUserPark.getUserId()));
            }
            if (CollectionUtils.isNotEmpty(userIds)) {
                List<SaasUser> saasUsers = saasUserDao.selectCsByIds(userIds);
                if (CollectionUtils.isNotEmpty(saasUsers)) {
                    List<SaasCsUserVo> saasCsUserVos = saasUsers.stream().map(saasUser -> {
                        SaasCsUserVo saasCsUserVo = new SaasCsUserVo();
                        BeanUtils.copyProperties(saasUser, saasCsUserVo);
                        return saasCsUserVo;
                    }).collect(Collectors.toList());
                    return ObjectResponse.success(saasCsUserVos);
                }
            }
        }
        return ObjectResponse.success(Lists.newArrayList());
    }

    @Override
    public ObjectResponse<SaasUserDto> haiDaCarManagerLogin(String userName, String password, Integer from) {
        try {
            SaasUser saasUser = saasUserDao.selectByUserName(userName);
            if (Objects.isNull(saasUser)|| !saasUser.getUsername().equals(userName)){
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_404.getCode(),"用户不存在");
            }
            SaasUserDto saasUserDto = new SaasUserDto();
            BeanUtils.copyProperties(saasUser, saasUserDto);
            saasUserDto.setFrom(from);
            //验证密码的正确性
            if (!DigestUtils.md5Hex(password+SALT).equalsIgnoreCase(saasUser.getPassword())){
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_401.getCode(),"用户名或密码错误");
            }
            String roleName = saasUserDao.getRoleName(saasUser.getRoleId());
            saasUserDto.setRoleName(roleName);
            if (!SaasUserDto.RoleEnum.ROLE_NAME8.getRoleName().equals(roleName)){
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_401.getCode(),"当前角色不允许登陆");
            }
            return ObjectResponse.success(saasUserDto);
        }catch (Exception e){
            log.error("[车场管家登陆接口异常],{}",e.getMessage());
            return ObjectResponse.failed(CodeConstantsEnum.ERROR.getCode(),CodeConstantsEnum.ERROR.getDesc());
        }
    }

    public static String decrypt(String encrypted) {
        try {
            // 创建 AES 密钥和 IV
            SecretKey key = new SecretKeySpec(SECRET_KEY.getBytes("UTF-8"), "AES");
            IvParameterSpec iv = new IvParameterSpec(INIT_VECTOR.getBytes("UTF-8"));
            // 创建解密器
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            cipher.init(Cipher.DECRYPT_MODE, key, iv);
            // 解密
            byte[] original = cipher.doFinal(Base64.getDecoder().decode(encrypted));
            // 返回解密后的明文
            return new String(original);
        }catch (Exception e) {
            log.error("[登录]解密失败,错误信息{}", e.getMessage());
        }
       return "";
    }
}
