package com.icetech.user.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.user.dao.UserPlateNumMapper;
import com.icetech.user.domain.entity.user.UserPlateNum;
import com.icetech.user.service.UserPlateNumService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 *  服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2024-04-16
 */
@Service
public class UserPlateNumServiceImpl extends BaseServiceImpl<UserPlateNumMapper, UserPlateNum> implements UserPlateNumService {

    /**
     * Description: 根据ID查询 对象信息 <br>
     * Version1.0 2024-04-16 by wangzhiwei创建
     *
     * @param id 对象id
     * @return UserPlateNum
     */
    @Override
    public UserPlateNum getUserPlateNumById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  对象信息 <br>
     * Version1.0 2024-04-16 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addUserPlateNum (UserPlateNum entity) {
        return save(entity);
    }

    /**
     * Description: 修改 对象信息 <br>
     * Version1.0 2024-04-16 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyUserPlateNum (UserPlateNum entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  对象信息 <br>
     * Version1.0 2024-04-16 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeUserPlateNumById (Long id) {
        UserPlateNum userPlateNum = getById(id);
        userPlateNum.setState(1);
        return updateById(userPlateNum);
    }

    @Override
    public Boolean removeUserPlateNumByPlateNum (String plateNum) {
        List<UserPlateNum> list = list(Wrappers.lambdaQuery(UserPlateNum.class).eq(UserPlateNum::getPlateNum, plateNum)
                .eq(UserPlateNum::getState, 0));
        if (CollectionUtils.isNotEmpty(list)){
            list.forEach(userPlateNum -> {
                userPlateNum.setState(1);
            });
        }
        return updateBatchById(list);
    }

    @Override
    public Boolean removeUserPlateNumByPlateNum (Long accountId,String plateNum) {
        List<UserPlateNum> list = list(Wrappers.lambdaQuery(UserPlateNum.class).eq(UserPlateNum::getAccountId,accountId).eq(UserPlateNum::getPlateNum, plateNum)
                .eq(UserPlateNum::getState, 0));
        if (CollectionUtils.isNotEmpty(list)){
            list.forEach(userPlateNum -> {
                userPlateNum.setState(1);
            });
        }
        return updateBatchById(list);
    }

    @Override
    public List<UserPlateNum> getByAccountId(Long accountId) {
        return list(Wrappers.lambdaQuery(UserPlateNum.class).eq(UserPlateNum::getAccountId,accountId).eq(UserPlateNum::getState,0));
    }

    @Override
    @Transactional
    public Boolean checkAddPlateNum(UserPlateNum entity) {
        List<UserPlateNum> list = getByAccountId(entity.getAccountId());
        if (CollectionUtils.isNotEmpty(list) && list.size()>=3){
            return false;
        }

        //判断是否已经存在 删除当前车牌绑定的用户信息
        removeUserPlateNumByPlateNum(entity.getAccountId(),entity.getPlateNum());
        //新增
        if (entity.getId()!=null){
            //更新
            entity.setState(0);
            entity.setAuthNum(Boolean.FALSE);
            return updateById(entity);
        }else {
            return addUserPlateNum(entity);
        }
    }

    @Override
    @Transactional
    public Boolean setDefaultPlateNum(Long id, Long accountId) {
        //更新当前用户为 常用车辆
        UserPlateNum userPlateNum = getById(id);
        userPlateNum.setDefaultNum(true);
        updateById(userPlateNum);
        //更新当前用户其他车辆为非 常用车辆
        List<UserPlateNum> list = getByAccountId(accountId);
        if (CollectionUtils.isNotEmpty(list)){
            update(new LambdaUpdateWrapper<UserPlateNum>()
                    .set(UserPlateNum::getDefaultNum, Boolean.FALSE)
                    .ne(UserPlateNum::getId, id)
                    .eq(UserPlateNum::getAccountId, accountId));
        }
        return Boolean.TRUE;
    }

}
