package com.icetech.user.service.impl;

import com.alibaba.fastjson.JSON;
import com.icetech.basics.constants.SecurityConstant;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.redis.handle.RedisHandle;
import com.icetech.user.dao.SaasNodeMapper;
import com.icetech.user.domain.entity.user.SaasNode;
import com.icetech.user.domain.vo.SaasLoginUser;
import com.icetech.user.service.SaasNodeService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 菜单表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2025-01-08
 */
@Service
public class SaasNodeServiceImpl extends BaseServiceImpl<SaasNodeMapper, SaasNode> implements SaasNodeService {

    @Autowired
    private SaasNodeMapper saasNodeMapper;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private RedisHandle redisHandle;

    @Override
    public List<String> getActionListByToken(String  token) {
        String key = SecurityConstant.USER_ACCESS_NODE_DATA + token;
        long expireMillis = 30 * 24 * 60 * 60 * 1000L;
        String nodes = redisTemplate.opsForValue().get(key);
        List<String> nodeList = new ArrayList<>();
        if (StringUtils.isBlank(nodes)) {
            String user = redisTemplate.opsForValue().get(SecurityConstant.TOKEN_PRE_OPS + token);
            //当前用户未登录或者登陆已经失效
            if (StringUtils.isNotBlank(user)) {
                SaasLoginUser loginUser = JSON.parseObject(user, SaasLoginUser.class);
                nodeList = redisHandle.cacheList(key, String.class, () -> saasNodeMapper.selectActionList(loginUser.getUserRole()), expireMillis);
            }
        } else {
            nodeList = JSON.parseArray(nodes, String.class);
        }
        return nodeList;
    }
    /**
     * Description: 根据ID查询 菜单表对象信息 <br>
     * Version1.0 2025-01-08 by fangct创建
     *
     * @param id 对象id
     * @return SaasNode
     */
    @Override
    public SaasNode getSaasNodeById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  菜单表对象信息 <br>
     * Version1.0 2025-01-08 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addSaasNode (SaasNode entity) {
        return save(entity);
    }

    /**
     * Description: 修改 菜单表对象信息 <br>
     * Version1.0 2025-01-08 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifySaasNode (SaasNode entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  菜单表对象信息 <br>
     * Version1.0 2025-01-08 by fangct创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeSaasNodeById (Long id) {
        return removeById(id);
    }

}
