package com.icetech.user.service.impl;

import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.user.dao.SaasInstitutionMapper;
import com.icetech.user.domain.entity.user.SaasInstitution;
import com.icetech.user.service.SaasInstitutionService;
import org.springframework.stereotype.Service;

/**
 * 机构表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2023-07-24
 */
@Service
public class SaasInstitutionServiceImpl extends BaseServiceImpl<SaasInstitutionMapper, SaasInstitution> implements SaasInstitutionService {

    /**
     * Description: 根据ID查询 机构表对象信息 <br>
     * Version1.0 2023-07-24 by wgy创建
     *
     * @param id 对象id
     * @return SaasInstitution
     */
    @Override
    public SaasInstitution getSaasInstitutionById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  机构表对象信息 <br>
     * Version1.0 2023-07-24 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addSaasInstitution (SaasInstitution entity) {
        return save(entity);
    }

    /**
     * Description: 修改 机构表对象信息 <br>
     * Version1.0 2023-07-24 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifySaasInstitution (SaasInstitution entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  机构表对象信息 <br>
     * Version1.0 2023-07-24 by wgy创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeSaasInstitutionById (Long id) {
        return removeById(id);
    }

}
