package com.icetech.user.service;

import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.user.domain.entity.user.UserPlateNum;

import java.util.List;

/**
 *  服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2024-04-16
 */
public interface UserPlateNumService extends IBaseService<UserPlateNum> {

    /**
     * Description: 根据ID查询 对象信息 <br>
     * Version1.0 2024-04-16 by wangzhiwei创建
     *
     * @param id 对象id
     * @return UserPlateNum
     */
    UserPlateNum getUserPlateNumById (Long id);

    /**
     * Description: 新增  对象信息 <br>
     * Version1.0 2024-04-16 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addUserPlateNum (UserPlateNum entity);

    /**
     * Description: 修改 对象信息 <br>
     * Version1.0 2024-04-16 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyUserPlateNum (UserPlateNum entity);

    /**
     * Description: 删除  对象信息 逻辑删除 <br>
     * Version1.0 2024-04-16 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeUserPlateNumById (Long id);

    /**
     * 根据plateNum删除
     * @param plateNum
     * @return
     */
    Boolean removeUserPlateNumByPlateNum (String plateNum);

    Boolean removeUserPlateNumByPlateNum (Long accountId,String plateNum);

    /**
     * 获取当前账户绑定的车牌信息
     * @param accountId
     * @return
     */
    List<UserPlateNum> getByAccountId(Long accountId);

    /**
     * 校验添加车牌
     * @param entity
     * @return
     */
    Boolean checkAddPlateNum(UserPlateNum entity);

    Boolean setDefaultPlateNum(Long id,Long accountId);
}
