package com.icetech.user.dao;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.icetech.user.anno.DS_ROAD;
import com.icetech.user.domain.entity.user.SaasUser;
import org.apache.ibatis.annotations.Param;

import java.util.Collection;
import java.util.List;
import java.util.Objects;

@DS_ROAD
public interface SaasUserDao {



    /**
     * 更新
     */
    int update(@Param("saasUser") SaasUser saasUser);

    /**
     * Load查询
     */
    SaasUser load(@Param("id") int id);

    List<SaasUser> selectByIds(@Param("ids") List<Long> ids);
    
    /**
     * Description: 查询客服用户
     * Version1.0 2023-11-29 by wgy 创建
     * 
     * @param ids 用户 id
     * @return java.util.List<com.icetech.user.domain.entity.user.SaasUser>       
     */
    List<SaasUser> selectCsByIds(@Param("ids") Collection<Integer> ids);

    /**
     * 用户名称查询用户信息
     * @param userName  
     * @returns
     */
    SaasUser selectUserName(@Param("userName") String userName);

    /**
     * 用户名称查询用户信息
     * @param userName
     * @return
     */
    default SaasUser selectByUserName(String userName) {
        SaasUser saasUser = selectUserName(userName);
        if (Objects.nonNull(saasUser) && saasUser.getIsDelete() == 0 && saasUser.getStatus() == 0) {
            return saasUser;
        }
        return null;
    }

    /**
     * seatNumber 查询用户信息
     * @param seatNumber    seatNumber
     * @return
     */
    SaasUser selectBySeatNum(@Param("seatNumber") String seatNumber);

    /**
     * 获取当前用户下关联的车场信息
     * @param userId
     * @return
     */
    List<Long> selectInstitutionIdsByUserId(@Param("userId") Integer userId);

    /**
     * 根据机构获取机构下的所有机构 以及子机构 id
     * @param institutionIds
     * @return
     */
    List<Long> selectAllInstitutionIdsByIds(@Param("institutionIds") List<Long> institutionIds);

    /**
     * 获取角色名称
     */
    String getRoleName(@Param("roleId") Integer roleId);

    /**
     * 获取角色
     * @param institutionId 组织结构id
     * @param roleNames     角色名称
     * @return List
     */
    List<SaasUser> getRoleIdsByInstitutionId(@Param("institutionId") Integer institutionId, @Param("roleNames") List<String> roleNames);

    /**
     * 获取机构下的所有用户
     * @param institutionId
     * @param roleNames
     * @return
     */
    List<SaasUser> getRoleIdsByInstitutionIds(@Param("institutionIds") List<Long> institutionId, @Param("roleNames") List<String> roleNames);

    /**
     * 根据机构获取用户信息
     * @param institutionIds
     * @return
     */
    List<Long> getUserIdsSaasUserParkByInstitutionIds(@Param("institutionIds") List<Long> institutionIds);

    /**
     * 根据车场获取用户信息
     * @param parkId
     * @return
     */
    List<Long> getUserIdsSaasUserParkByParkId(@Param("parkId") Long parkId);

    /**
     * 根据车场获取用户信息
     * @param parkIds
     * @return
     */
    List<Long> getUserIdsSaasUserParkByParkIds(@Param("parkIds") List<Long> parkIds);

    /**
     * 获取用户信息
     * @param userIds
     * @param roleNames
     * @return
     */
    List<SaasUser> getUserByUserIdAndRoleName(@Param("userIds") List<Long> userIds, @Param("roleNames") List<String> roleNames);

    /**
     * 获取当前机构下的所有子机构信息
     * @param institutionId
     * @return
     */
    String getSubInstitutionId(@Param("institutionId") Integer institutionId);

    /**
     * 查询当前用户是否属于此机构或它的下级机构
     * @param userId 用户ID
     * @param institutionId 机构ID
     * @return count结果，大于0时属于
     */
    Integer isSonInstitution(@Param("userId") Integer userId, @Param("institutionId") Integer institutionId);

    /**
     * 获取当前机构下的所有子机构
     * @param institutionId
     * @return
     */
    List<Long> getSubInstitution( @Param("institutionId") Long institutionId);

    /**
     * 获取角色id通过角色名称
     *
     * @param roleName
     * @return
     */
    Integer getSassRoleIdByName(@Param("roleName")  String roleName);

    /**
     * 通过角色id获取用户信息
     *
     * @param roleId
     * @return
     */
    List<SaasUser> getSassUserByRoleId (@Param("roleId") Integer roleId);
}
