/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.user.service.impl;

import com.alibaba.fastjson.JSON;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.redis.handle.RedisHandle;
import com.icetech.user.dao.SaasNodeMapper;
import com.icetech.user.domain.entity.user.SaasNode;
import com.icetech.user.domain.vo.SaasLoginUser;
import com.icetech.user.service.SaasNodeService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class SaasNodeServiceImpl
extends BaseServiceImpl<SaasNodeMapper, SaasNode>
implements SaasNodeService {
    @Autowired
    private SaasNodeMapper saasNodeMapper;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private RedisHandle redisHandle;

    @Override
    public List<String> getActionListByToken(String token) {
        String key = "user:myAccessNode:data_" + token;
        long expireMillis = 2592000000L;
        String nodes = (String)this.redisTemplate.opsForValue().get((Object)key);
        List nodeList = new ArrayList();
        if (StringUtils.isBlank((CharSequence)nodes)) {
            String user = (String)this.redisTemplate.opsForValue().get((Object)("user:info:" + token));
            if (StringUtils.isNotBlank((CharSequence)user)) {
                SaasLoginUser loginUser = (SaasLoginUser)JSON.parseObject((String)user, SaasLoginUser.class);
                nodeList = this.redisHandle.cacheList(key, String.class, () -> this.saasNodeMapper.selectActionList(loginUser.getUserRole()), expireMillis);
            }
        } else {
            nodeList = JSON.parseArray((String)nodes, String.class);
        }
        return nodeList;
    }

    @Override
    public SaasNode getSaasNodeById(Long id) {
        return (SaasNode)this.getById(id);
    }

    @Override
    public Boolean addSaasNode(SaasNode entity) {
        return this.save(entity);
    }

    @Override
    public Boolean modifySaasNode(SaasNode entity) {
        return this.updateById(entity);
    }

    @Override
    public Boolean removeSaasNodeById(Long id) {
        return this.removeById(id);
    }
}

