package com.icetech.user.domain.entity.user;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2024-04-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_user_plate_num")
public class UserPlateNum implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键自增
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 账户id
     */
    private Long accountId;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 是否是默认车牌1=是 0=否
     */
    private Boolean defaultNum;
    /**
     * 是否认证1=是 0=否
     */
    private Boolean authNum;
    /**
     * 状态 0=正常 1=删除
     */
    private Integer state;
    /**
     * 扩展信息 车辆认证信息
     */
    private String ext;


}
