package com.icetech.user.domain.entity.user;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 岗亭和收费员关联表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2024-11-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_toll_box_user")
public class TollBoxUser implements Serializable {

    private static final long serialVersionUID=1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 停车场ID
     */
    private Integer parkId;

    /**
     * 用户管理员id
     */
    private Integer userId;

    /**
     * 收费员对应岗亭id
     */
    private Integer boxId;

    @TableField(fill = FieldFill.INSERT)
    private Date createTime;


}
