package com.icetech.user.domain.entity.user;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 *  用户表
 *
 *  @author wangzw
 */
@Data
public class SaasUser implements Serializable {
    private static final long serialVersionUID = 42L;

    /**
     * iD (主健自增)
     */
    private int id;

    /**
     * 用户名
     */
    private String username;

    /**
     * 密码
     */
    private String password;

    /**
     * 真实姓名
     */
    private String name;

    /**
     * 联系方式
     */
    private String phone;

    /**
     * 状态（0正常、1冻结
     */
    private int status;

    /**
     * 所属机构
     */
    private int institutionId;

    /**
     * 角色ID
     */
    private int roleId;

    /**
     * 是否删除（0正常、1删除）
     */
    private int isDelete;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 添加时间
     */
    private Date addTime;

    /**
     * 最后登录时间
     */
    private Date lastLogin;

    /**
     * 最后登录ip
     */
    private String lastIp;

    /**
     * 用户岗位
     */
    private String userPost;
    /**
     * 登录端口 1：车场管理平台 2：车场帮APP:3：车场监控:4：知位岗亭小程序 默认全部
     */
    private String loginPortType;

    /**
     * 是否开启坐席对讲服务 1是，0否 默认0
     */
    private Integer isuseSeatservice;

    /**
     * 坐席类型 1 云坐席、2 本地坐席、3 车场帮app
     */
    private Integer seatType;

    /**
     * 云坐席/本地坐席客服坐席分机号
     */
    private String seatNumber;

    /**
     * 是否为客服，1-是
     */
    private Integer isCs;

    /**
     * 客服编号
     */
    private String csCode;
}
