package com.icetech.user.domain.entity.user;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 菜单表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2025-01-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_saas_node")
public class SaasNode implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 菜单名
     */
    private String title;

    /**
     * action/url
     */
    private String action;

    /**
     * 状态（0：正常，1：删除，默认0）
     */
    private Integer status;

    /**
     * 备注
     */
    private String remark;

    /**
     * 排序
     */
    private Integer sort;

    /**
     * 父级ID
     */
    private Integer pid;

    /**
     * 菜单等级 1,2,3
     */
    private Integer nlevel;

    /**
     * 所属模块id 只有一级菜单才有此值
     */
    private Integer mid;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 添加时间
     */
    private Date addtime;

    /**
     * 是否展示（0：不展示，1：展示，默认0）
     */
    private Integer isShow;

    /**
     * 最后修改人
     */
    private String updateUser;

    /**
     * 最后修改时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 菜单属性0全部 1白牌 2知位
     */
    private Integer accessType;


}
