/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.third.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.icetech.third.utils.JedisUtils;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;

@Component
public class RedisUtils {
    private static final Logger log = LoggerFactory.getLogger(RedisUtils.class);
    @Resource(name="stringRedisTemplate")
    private RedisTemplate<String, String> redisTemplate;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Value(value="${spring.redis.host}")
    private String redisHost;
    @Value(value="${spring.redis.port}")
    private Integer redisPort;
    @Value(value="${spring.redis.database}")
    private Integer redisDatabase;
    @Value(value="${spring.redis.password}")
    private String redisPassword;

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }

    public boolean isValidity() {
        try {
            this.set("test", "test", 1L);
            return true;
        }
        catch (Exception e) {
            log.error("redis\u8fde\u63a5\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    public void remove(String ... keys) {
        for (String key : keys) {
            this.remove(key);
        }
    }

    public void removePattern(String pattern) {
        this.redisTemplate.delete((Collection)this.redisTemplate.keys((Object)pattern));
    }

    public Set<String> keys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    public Boolean remove(String key) {
        return this.redisTemplate.delete((Object)key);
    }

    public boolean exists(String key) {
        return Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)key));
    }

    public <T> T get(String key, Class<T> clazz) {
        String cache = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (StringUtils.isBlank((CharSequence)cache)) {
            return null;
        }
        return (T)JSON.parseObject((String)cache, clazz);
    }

    public <T> T get(String key, TypeReference<T> type) {
        String cache = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (StringUtils.isBlank((CharSequence)cache)) {
            return null;
        }
        return (T)JSON.parseObject((String)cache, type, (Feature[])new Feature[0]);
    }

    public String get(String key) {
        return (String)this.redisTemplate.opsForValue().get((Object)key);
    }

    public <T> T get(String key, Type typeSub) {
        String cache = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (StringUtils.isBlank((CharSequence)cache)) {
            return null;
        }
        return (T)JSON.parseObject((String)cache, (Type)typeSub, (Feature[])new Feature[0]);
    }

    public <T> List<T> getListValue(String key, Class<T> clazz) {
        String cache = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (StringUtils.isBlank((CharSequence)cache)) {
            return null;
        }
        return JSON.parseArray((String)cache, clazz);
    }

    public boolean set(String key, Object value) {
        String cache = JSON.toJSONString((Object)value);
        this.redisTemplate.opsForValue().set((Object)key, (Object)cache);
        return true;
    }

    public boolean set(String key, Object value, long expireSecond) {
        String cache = JSON.toJSONString((Object)value);
        this.redisTemplate.opsForValue().set((Object)key, (Object)cache, expireSecond, TimeUnit.SECONDS);
        return true;
    }

    public boolean set(String key, Object value, long expireSecond, TimeUnit timeUnit) {
        String cache = JSON.toJSONString((Object)value);
        this.redisTemplate.opsForValue().set((Object)key, (Object)cache, expireSecond, timeUnit);
        return true;
    }

    public boolean setExpireMilliSeconds(String key, Object value, Long milliSeconds) {
        String cache = JSON.toJSONString((Object)value);
        this.redisTemplate.opsForValue().set((Object)key, (Object)cache, milliSeconds.longValue(), TimeUnit.MILLISECONDS);
        return true;
    }

    public boolean tryGetDistributedLock(String key, String requestId) {
        return this.tryGetDistributedLock(key, requestId, 3L);
    }

    public boolean tryGetDistributedLock(String key, String requestId, Long timeout) {
        String lockKey = "LOCK_" + key;
        for (int i = 0; i < 30; ++i) {
            Boolean locked = this.redisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)requestId, timeout.longValue(), TimeUnit.SECONDS);
            if (locked != null && locked.booleanValue()) {
                log.info("\u7b2c{}\u6b21\u6210\u529f\u83b7\u53d6\u5230\u4e86\u9501{}", (Object)(i + 1), (Object)lockKey);
                return true;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                log.warn("Redis\u9501\u83b7\u53d6\u7b49\u5f85\u5931\u8d25", (Throwable)e);
            }
        }
        log.info("\u672a\u6210\u529f\u83b7\u53d6\u5230\u9501{}", (Object)lockKey);
        return false;
    }

    public boolean tryGetDistributedLock(String key, String value, Long timeout, Long waitTime) {
        String lockKey = "lock:" + key;
        long now = System.currentTimeMillis();
        while (now <= now + waitTime) {
            Boolean locked = this.redisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)value, timeout.longValue(), TimeUnit.SECONDS);
            if (locked != null && locked.booleanValue()) {
                return true;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                log.warn("Redis\u9501\u83b7\u53d6\u7b49\u5f85\u5931\u8d25", (Throwable)e);
            }
            now = System.currentTimeMillis();
        }
        log.info("\u672a\u6210\u529f\u83b7\u53d6\u5230\u9501{}", (Object)lockKey);
        return false;
    }

    public boolean tryLock(String key, String value, long timeout) {
        String lockKey = "lock:" + key;
        try {
            Boolean result = this.stringRedisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)value, timeout, TimeUnit.MILLISECONDS);
            log.info("[Redis\u9501]\u83b7\u53d6\u9501[{}]\u7ed3\u679c: {}", (Object)lockKey, (Object)result);
            return result != null && result != false;
        }
        catch (Exception e) {
            log.info("[Redis\u9501\u83b7\u53d6\u5931\u8d25]\u83b7\u53d6\u9501[{}]\u7ed3\u679c:", (Object)lockKey, (Object)e);
            return false;
        }
    }

    public String getLockValue(String key) {
        String lockKey = "lock:" + key;
        return (String)this.stringRedisTemplate.opsForValue().get((Object)lockKey);
    }

    public boolean updateLockValue(String key, String value) {
        String lockKey = "lock:" + key;
        Boolean result = this.stringRedisTemplate.opsForValue().setIfPresent((Object)lockKey, (Object)value);
        log.info("[Redis\u9501]\u66f4\u65b0\u9501[{}]\u5b58\u50a8\u503c\u4e3a[{}]: {}", new Object[]{lockKey, value, result});
        return result != null && result != false;
    }

    public void releaseLock(String key) {
        String lockKey = "lock:" + key;
        this.stringRedisTemplate.delete((Object)lockKey);
    }

    public boolean releaseDistributedLock(String key, String requestId) {
        String lockKey = "LOCK_" + key;
        String val = (String)this.stringRedisTemplate.opsForValue().get((Object)lockKey);
        if (val != null && val.equals(requestId)) {
            log.info("\u6210\u529f\u91ca\u653e\u4e86\u9501 {}\uff0crequestId\uff1a{}", (Object)lockKey, (Object)requestId);
            this.remove(lockKey);
            return true;
        }
        log.error("\u91cd\u8981\u63d0\u793a\uff1a\u672a\u6210\u529f\u91ca\u653e\u9501 {}\uff0crequestId\uff1a{}", (Object)lockKey, (Object)requestId);
        return false;
    }

    public <T> T hGet(String key, String field, Class<T> clazz) {
        Object cacheObj = this.redisTemplate.opsForHash().get((Object)key, (Object)field);
        if (cacheObj == null) {
            return null;
        }
        return (T)JSON.parseObject((String)cacheObj.toString(), clazz);
    }

    public <T> Map<String, T> hGetAll(String key, Class<T> clazz) {
        Map cacheMap = this.redisTemplate.opsForHash().entries((Object)key);
        if (MapUtils.isEmpty((Map)cacheMap)) {
            return Collections.emptyMap();
        }
        try {
            return cacheMap.entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey().toString(), entry -> entry.getValue() == null ? null : JSON.parseObject((String)entry.getValue().toString(), (Class)clazz), (old, newer) -> newer, LinkedHashMap::new));
        }
        catch (Exception e) {
            log.warn("Redis Map\u53cd\u5e8f\u5217\u5316\u5931\u8d25|{}|{}", new Object[]{key, clazz.getName(), e});
            return Collections.emptyMap();
        }
    }

    public <T> List<T> hMultiGet(String key, Class<T> clazz, String ... fields) {
        List cacheList = this.redisTemplate.opsForHash().multiGet((Object)key, Arrays.asList(fields));
        if (CollectionUtils.isEmpty((Collection)cacheList)) {
            return Collections.emptyList();
        }
        return cacheList.stream().map(value -> JSON.parseObject((String)value.toString(), (Class)clazz)).collect(Collectors.toList());
    }

    public void hPut(String key, String hashKey, Object value) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)hashKey, (Object)JSON.toJSONString((Object)value));
    }

    public void hPut(String key, String hashKey, Object value, long timeout) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)hashKey, (Object)JSON.toJSONString((Object)value));
        this.redisTemplate.expire((Object)key, timeout, TimeUnit.SECONDS);
    }

    public void hMultiPut(String key, Map<String, Object> fieldValueMap) {
        Jedis jedisIns = JedisUtils.getJedisIns(this.redisHost, this.redisPort, this.redisPassword, this.redisDatabase);
        Map<String, String> cacheMap = fieldValueMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JSON.toJSONString(entry.getValue())));
        jedisIns.hmset(key, cacheMap);
    }

    public void hPutAll(String key, Map<String, Object> maps) {
        Map<String, String> cacheMap = maps.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JSON.toJSONString(entry.getValue())));
        this.redisTemplate.opsForHash().putAll((Object)key, cacheMap);
    }

    public Boolean hPutIfAbsent(String key, String hashKey, Object value) {
        return this.redisTemplate.opsForHash().putIfAbsent((Object)key, (Object)hashKey, (Object)JSON.toJSONString((Object)value));
    }

    public Long hDelete(String key, String ... fields) {
        return this.redisTemplate.opsForHash().delete((Object)key, (Object[])fields);
    }

    public boolean hExists(String key, String field) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)field);
    }

    public Long hIncrBy(String key, String field, long increment) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)field, increment);
    }

    public Double hIncrByFloat(String key, String field, double delta) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)field, delta);
    }

    public Set<String> hKeys(String key) {
        Set list = this.redisTemplate.opsForHash().keys((Object)key);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptySet();
        }
        return list.stream().map(Object::toString).collect(Collectors.toSet());
    }

    public Long hSize(String key) {
        return this.redisTemplate.opsForHash().size((Object)key);
    }

    public <T> List<T> hValues(String key, Class<T> clazz) {
        List cacheValues = this.redisTemplate.opsForHash().values((Object)key);
        if (CollectionUtils.isEmpty((Collection)cacheValues)) {
            return Collections.emptyList();
        }
        return cacheValues.stream().map(value -> JSON.parseObject((String)value.toString(), (Class)clazz)).collect(Collectors.toList());
    }

    public Cursor<Map.Entry<Object, Object>> hScan(String key, ScanOptions options) {
        return this.redisTemplate.opsForHash().scan((Object)key, options);
    }

    public <T> T lIndex(String key, long index, Class<T> clazz) {
        String cacheObj = (String)this.redisTemplate.opsForList().index((Object)key, index);
        if (StringUtils.isBlank((CharSequence)cacheObj)) {
            return null;
        }
        return (T)JSON.parseObject((String)cacheObj, clazz);
    }

    public <T> List<T> lRange(String key, long start, long end, Class<T> clazz) {
        List cacheList = this.redisTemplate.opsForList().range((Object)key, start, end);
        if (CollectionUtils.isEmpty((Collection)cacheList)) {
            return Collections.emptyList();
        }
        return cacheList.stream().map(value -> JSON.parseObject((String)value, (Class)clazz)).collect(Collectors.toList());
    }

    public Long lLeftPush(String key, Object value) {
        return this.redisTemplate.opsForList().leftPush((Object)key, (Object)JSON.toJSONString((Object)value));
    }

    public Long lLeftPushAll(String key, Object ... value) {
        List values = Stream.of(value).map(JSON::toJSONString).collect(Collectors.toList());
        return this.redisTemplate.opsForList().leftPushAll((Object)key, values);
    }

    public Long lLeftPushAll(String key, Collection<Object> value) {
        List values = value.stream().map(JSON::toJSONString).collect(Collectors.toList());
        return this.redisTemplate.opsForList().leftPushAll((Object)key, values);
    }

    public Long lLeftPushIfPresent(String key, Object value) {
        return this.redisTemplate.opsForList().leftPushIfPresent((Object)key, (Object)JSON.toJSONString((Object)value));
    }

    public Long lLeftPush(String key, String pivot, Object value) {
        return this.redisTemplate.opsForList().leftPush((Object)key, (Object)pivot, (Object)JSON.toJSONString((Object)value));
    }

    public Long lRightPush(String key, Object value) {
        return this.redisTemplate.opsForList().rightPush((Object)key, (Object)JSON.toJSONString((Object)value));
    }

    public Long lRightPushAll(String key, Object ... value) {
        List values = Stream.of(value).map(JSON::toJSONString).collect(Collectors.toList());
        return this.redisTemplate.opsForList().rightPushAll((Object)key, values);
    }

    public Long lRightPushAll(String key, Collection<Object> value) {
        List values = value.stream().map(JSON::toJSONString).collect(Collectors.toList());
        return this.redisTemplate.opsForList().rightPushAll((Object)key, values);
    }

    public Long lRightPushIfPresent(String key, Object value) {
        return this.redisTemplate.opsForList().rightPushIfPresent((Object)key, (Object)JSON.toJSONString((Object)value));
    }

    public Long lRightPush(String key, String pivot, Object value) {
        return this.redisTemplate.opsForList().rightPush((Object)key, (Object)pivot, (Object)JSON.toJSONString((Object)value));
    }

    public void lSet(String key, long index, Object value) {
        this.redisTemplate.opsForList().set((Object)key, index, (Object)JSON.toJSONString((Object)value));
    }

    public <T> T lLeftPop(String key, Class<T> clazz) {
        String cache = (String)this.redisTemplate.opsForList().leftPop((Object)key);
        if (cache == null) {
            return null;
        }
        return (T)JSON.parseObject((String)cache, clazz);
    }

    public <T> T lBLeftPop(String key, long timeout, TimeUnit unit, Class<T> clazz) {
        String cache = (String)this.redisTemplate.opsForList().leftPop((Object)key, timeout, unit);
        if (cache == null) {
            return null;
        }
        return (T)JSON.parseObject((String)cache, clazz);
    }

    public <T> T lRightPop(String key, Class<T> clazz) {
        String cache = (String)this.redisTemplate.opsForList().rightPop((Object)key);
        if (cache == null) {
            return null;
        }
        return (T)JSON.parseObject((String)cache, clazz);
    }

    public <T> T lBRightPop(String key, long timeout, TimeUnit unit, Class<T> clazz) {
        String cache = (String)this.redisTemplate.opsForList().rightPop((Object)key, timeout, unit);
        if (cache == null) {
            return null;
        }
        return (T)JSON.parseObject((String)cache, clazz);
    }

    public <T> T lRightPopAndLeftPush(String sourceKey, String destinationKey, Class<T> clazz) {
        String cache = (String)this.redisTemplate.opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey);
        if (cache == null) {
            return null;
        }
        return (T)JSON.parseObject((String)cache, clazz);
    }

    public <T> T lBRightPopAndLeftPush(String sourceKey, String destinationKey, long timeout, TimeUnit unit, Class<T> clazz) {
        String cache = (String)this.redisTemplate.opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey, timeout, unit);
        if (cache == null) {
            return null;
        }
        return (T)JSON.parseObject((String)cache, clazz);
    }

    public Long lRemove(String key, long index, Object value) {
        return this.redisTemplate.opsForList().remove((Object)key, index, (Object)JSON.toJSONString((Object)value));
    }

    public Long lRemoveOriginVal(String key, long index, Object value) {
        return this.redisTemplate.opsForList().remove((Object)key, index, (Object)value.toString());
    }

    public void lTrim(String key, long start, long end) {
        this.redisTemplate.opsForList().trim((Object)key, start, end);
    }

    public Long lLen(String key) {
        return this.redisTemplate.opsForList().size((Object)key);
    }

    public void expire(String key, long expireTime) {
        this.redisTemplate.expire((Object)key, expireTime, TimeUnit.SECONDS);
    }

    public void convertAndSend(String channel, String content) {
        this.redisTemplate.convertAndSend(channel, (Object)content);
    }

    public boolean setIfAbsent(String key, Object value, long timeout) {
        String cache = JSON.toJSONString((Object)value);
        Boolean aBoolean = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)cache, timeout, TimeUnit.SECONDS);
        return aBoolean != null && aBoolean != false;
    }

    public boolean setNoProfile(String key, Object value, long expireSecond) {
        String cache = JSON.toJSONString((Object)value);
        this.redisTemplate.opsForValue().set((Object)key, (Object)cache, expireSecond, TimeUnit.SECONDS);
        return true;
    }
}

