/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.third.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.TimeZone;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    public static ObjectMapper mapper = new ObjectMapper();

    public static String toJson(Object object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String toPrettyJson(Object object) {
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T fromJson(String jsonString, Class<T> valueType) {
        Validate.notNull(valueType, (String)"valueType is null ", (Object[])new Object[0]);
        if (jsonString == null || "".equals(jsonString)) {
            return null;
        }
        try {
            return (T)mapper.readValue(jsonString, valueType);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T fromJsonNoEx(String jsonString, Class<T> valueType) {
        Validate.notNull(valueType, (String)"valueType is null ", (Object[])new Object[0]);
        if (jsonString == null || "".equals(jsonString)) {
            return null;
        }
        try {
            return (T)mapper.readValue(jsonString, valueType);
        }
        catch (Exception e) {
            log.error(String.valueOf(e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static <T> T fromJson(InputStream is, Class<T> valueType) {
        Validate.notNull(valueType, (String)"valueType is null ", (Object[])new Object[0]);
        Validate.notNull((Object)is, (String)"inputStream is null", (Object[])new Object[0]);
        try {
            return (T)mapper.readValue(is, valueType);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T extends Collection<S>, S> T fromJson(String jsonString, Class<T> collectionType, Class<S> elementType) {
        Validate.notNull(collectionType, (String)"collectionType is null", (Object[])new Object[0]);
        Validate.notNull(elementType, (String)"elementType is null", (Object[])new Object[0]);
        if (jsonString == null || "".equals(jsonString)) {
            return null;
        }
        try {
            return (T)((Collection)mapper.readValue(jsonString, (JavaType)mapper.getTypeFactory().constructCollectionType(collectionType, elementType)));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T fromJson(String jsonString, TypeReference<T> typeReference) {
        Validate.notNull(typeReference, (String)"typeReference is null", (Object[])new Object[0]);
        if (jsonString == null || "".equals(jsonString)) {
            return null;
        }
        try {
            return (T)mapper.readValue(jsonString, typeReference);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private JsonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL);
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        mapper.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

