/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.third.utils;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateRangeUtils {
    public static List<Integer> getCurrentHours() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("HH");
        String hour = sdf.format(date);
        Integer integer = Integer.valueOf(hour);
        ArrayList hours = Lists.newArrayList();
        for (int i = 0; i <= integer - 1; ++i) {
            hours.add(i);
        }
        return hours;
    }

    public static int getHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11);
    }

    public static List<Integer> getNowHours() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        List<Integer> hours = DateRangeUtils.get24Hours();
        int nowhour = DateRangeUtils.getHour(new Date());
        for (Integer integer : hours) {
            if (integer >= nowhour) continue;
            list.add(integer);
        }
        return list;
    }

    public static List<Integer> get24DayHours() {
        ArrayList res = Lists.newArrayList();
        for (int i = 0; i < 24; ++i) {
            Integer integer = i;
            res.add(integer);
        }
        return res;
    }

    public static List<Integer> get24Hours() {
        ArrayList res = Lists.newArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("HH");
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        String firstHour = sdf.format(calendar.getTime());
        res.add(Integer.valueOf(firstHour));
        for (int i = 0; i < 23; ++i) {
            calendar.add(10, 1);
            Date time = calendar.getTime();
            String hour = sdf.format(time);
            Integer integer = Integer.valueOf(hour);
            res.add(integer);
        }
        return res;
    }

    public static List<String> getDays(Integer day) {
        return DateRangeUtils.getDaysMultiformat(day, 0);
    }

    public static List<String> getDaysMultiformat(Integer day, int type) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd");
        if (type == 1) {
            sdf = new SimpleDateFormat("yyyy/MM/dd");
        }
        ArrayList res = Lists.newArrayList();
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -day.intValue());
        String firstDay = sdf.format(calendar.getTime());
        res.add(firstDay);
        for (int i = 0; i < day - 1; ++i) {
            calendar.add(5, 1);
            Date time = calendar.getTime();
            String format = sdf.format(time);
            res.add(format);
        }
        return res;
    }

    public static List<String> getMonths(int nowyear) {
        ArrayList res = Lists.newArrayList();
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        if (year != nowyear) {
            month = 12;
            year = nowyear;
        }
        for (int i = 1; i <= month; ++i) {
            String str = year + "/";
            str = (i + "").length() == 1 ? str + "0" + i : str + i;
            res.add(str);
        }
        return res;
    }

    public static Long getTodayTime() {
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTimeInMillis() / 1000L;
    }

    public static Long getDayTime(Integer day) {
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.add(5, -day.intValue());
        return c.getTimeInMillis() / 1000L;
    }

    public static Long getNHourTime(Integer integer) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(DateRangeUtils.getNowHourTime() * 1000L);
        c.add(10, -integer.intValue());
        return c.getTimeInMillis() / 1000L;
    }

    public static Long getYesterdayHourTime(int pastHour) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(DateRangeUtils.getNowHourTime() * 1000L);
        c.add(10, -pastHour);
        return c.getTimeInMillis() / 1000L;
    }

    public static Long get24HourTime() {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(DateRangeUtils.getNowHourTime() * 1000L);
        c.add(10, -24);
        return c.getTimeInMillis() / 1000L;
    }

    public static long getNowHourTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:00:00");
        Date parse = null;
        try {
            parse = sdf.parse(sdf.format(new Date()));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return parse.getTime() / 1000L;
    }

    public static long getTimeHourTime(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:00:00");
        Date parse = null;
        try {
            parse = sdf.parse(time);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return parse.getTime() / 1000L;
    }

    public static Long getNextTimeHourTime(Long time, Integer hour) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time * 1000L);
        c.add(10, hour);
        return c.getTimeInMillis() / 1000L;
    }

    public static int getDaysOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getActualMaximum(5);
    }

    public static List<String> getMonthDays(String month) throws Exception {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        int day = DateRangeUtils.getDaysOfMonth(sdf1.parse(month + "-01"));
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd");
        ArrayList res = Lists.newArrayList();
        SimpleDateFormat sdfs = new SimpleDateFormat("yyyy-MM-dd");
        Date date = sdfs.parse(month + "-" + day);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -day);
        String firstDay = sdf.format(calendar.getTime());
        res.add(firstDay);
        for (int i = 0; i < day; ++i) {
            calendar.add(5, 1);
            Date time = calendar.getTime();
            String format = sdf.format(time);
            res.add(format);
        }
        return res;
    }

    public static List<String> getYearQuarterRangeTableName(Date startDate) {
        if (startDate == null) {
            startDate = new Date();
        }
        Date nowDate = new Date();
        ArrayList<String> list = new ArrayList<String>();
        String quarter1 = DateRangeUtils.getYearQuarter(nowDate);
        list.add(quarter1);
        String startQuarter = DateRangeUtils.getYearQuarter(startDate);
        if (startQuarter.equals(quarter1)) {
            return list;
        }
        Calendar calendar = Calendar.getInstance();
        for (int i = 0; i < 4; ++i) {
            calendar.add(2, -3);
            String yearQuarter = DateRangeUtils.getYearQuarter(calendar.getTime());
            if (yearQuarter.equals(startQuarter)) {
                list.add(yearQuarter);
                break;
            }
            list.add(yearQuarter);
        }
        return list;
    }

    private static String getYearQuarter(Date startDate) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(startDate);
        int paraYear = instance.get(1);
        int paraMonth = instance.get(2);
        int jidu = (paraMonth + 3) / 3;
        return paraYear + "q" + jidu;
    }
}

