/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.third.service.third;

import com.icetech.cloudcenter.api.third.ThirdParkService;
import com.icetech.third.dao.third.ThirdParkDao;
import com.icetech.third.domain.entity.third.ThirdInfo;
import com.icetech.third.domain.entity.third.ThirdPark;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThirdParkServiceImpl
implements ThirdParkService {
    private static final Logger log = LoggerFactory.getLogger(ThirdParkServiceImpl.class);
    @Autowired
    private ThirdParkDao thirdParkDao;

    public ThirdPark selectByParkId(Long parkId) {
        return this.thirdParkDao.selectByParkId(parkId);
    }

    public List<ThirdInfo> selectThirdByParkId(Long parkId) {
        return this.thirdParkDao.selectThirdByParkId(parkId);
    }

    public ThirdInfo selectThirdByParkIdPID(Long parkId, String pid) {
        return this.thirdParkDao.selectThirdByParkIdPID(parkId, pid);
    }

    public List<Long> selectParkByPid(String pid) {
        return this.thirdParkDao.selectParkByPid(pid);
    }

    public boolean checkPermissionService(long parkId, String serviceName) {
        List<String> services = this.thirdParkDao.selectPermissionServicesByParkId(parkId);
        Set serviceNames = services.stream().flatMap(service -> Stream.of(service.split(","))).collect(Collectors.toSet());
        return serviceNames.contains(serviceName);
    }

    public Integer insertInfoByThird(ThirdPark thirdPark) {
        return this.thirdParkDao.insertInfoByThird(thirdPark);
    }

    public ThirdInfo selectNoSenConfig(Long parkId) {
        return this.thirdParkDao.selectNoSenConfig(parkId);
    }

    public List<ThirdInfo> selectNoSenConfigs(Long parkId) {
        return this.thirdParkDao.selectNoSenConfigs(parkId);
    }

    public Integer deleteByIds(List<Integer> ids) {
        return this.thirdParkDao.deleteByIds(ids);
    }

    public List<ThirdPark> findAllByParkId(Long parkId) {
        return this.thirdParkDao.findAllByParkId(parkId);
    }

    public List<ThirdInfo> selectThirdByParkIdAndService(Long parkId, String serviceName) {
        return this.thirdParkDao.selectThirdByParkIdAndService(parkId, serviceName);
    }
}

