/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.third.service.third;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.third.ThirdAttributeService;
import com.icetech.cloudcenter.api.third.ThirdInfoService;
import com.icetech.cloudcenter.api.third.ThirdParamService;
import com.icetech.cloudcenter.api.third.ThirdParkRefService;
import com.icetech.cloudcenter.domain.response.ThirdParkInfoResponse;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.domain.entity.park.ThirdParkMessage;
import com.icetech.redis.handle.RedisHandle;
import com.icetech.third.dao.third.ThirdInfoDao;
import com.icetech.third.dao.third.ThirdParkDao;
import com.icetech.third.domain.entity.third.BstAdSpace;
import com.icetech.third.domain.entity.third.PushExtend;
import com.icetech.third.domain.entity.third.ThirdAttribute;
import com.icetech.third.domain.entity.third.ThirdBstPark;
import com.icetech.third.domain.entity.third.ThirdInfo;
import com.icetech.third.domain.entity.third.ThirdParam;
import com.icetech.third.domain.entity.third.ThirdParkRef;
import com.icetech.third.domain.entity.third.ThirdTongchengPark;
import com.icetech.third.domain.entity.third.ThirdTongchengParkChannel;
import com.icetech.third.service.ThirdTongchengParkChannelService;
import com.icetech.third.service.ThirdTongchengParkService;
import com.icetech.third.service.extend.PushExtendService;
import com.icetech.third.service.third.BstAdSpaceService;
import com.icetech.third.service.third.ThirdBstParkService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ThirdInfoServiceImpl
implements ThirdInfoService {
    private static final Logger log = LoggerFactory.getLogger(ThirdInfoServiceImpl.class);
    @Autowired
    private ThirdInfoDao thirdInfoDao;
    @Autowired
    private ThirdParkDao thirdParkDao;
    @Autowired
    private PushExtendService pushExtendService;
    @Autowired
    private ThirdParkRefService thirdParkRefService;
    @Value(value="${abjh.appid}")
    private String appId;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ThirdAttributeService thirdAttributeService;
    @Autowired
    private ThirdParamService thirdParamService;
    private final Integer isSuccess = 1;
    private final Integer THIRD_FEE = 1;
    private final Integer THIRD_QR = 2;
    @Autowired
    private ThirdBstParkService thirdBstParkService;
    @Autowired
    private BstAdSpaceService bstAdSpaceService;
    @Resource
    private RedisHandle redisHandle;
    public static final String BST_SPACE_KEY = "bst:park:space:";
    @Autowired
    private ThirdTongchengParkService thirdTongchengParkService;
    @Autowired
    private ThirdTongchengParkChannelService tongchengParkChannelService;

    public List<ThirdParkInfoResponse> selectByPid(String pid) {
        return this.thirdInfoDao.selectByPid(pid);
    }

    public ObjectResponse<ThirdInfo> selectThirdInfo(String pid) {
        ThirdInfo thirdInfo = new ThirdInfo();
        thirdInfo.setPid(pid);
        thirdInfo = (ThirdInfo)this.thirdInfoDao.selectById(thirdInfo);
        if (Objects.nonNull(thirdInfo)) {
            return ObjectResponse.success((Object)thirdInfo);
        }
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
    }

    public ThirdInfo selectById(ThirdInfo para) {
        return (ThirdInfo)this.thirdInfoDao.selectById(para);
    }

    public ThirdInfo selectParkThirdConf(Long parkId, String pId) {
        return this.thirdParkDao.selectThirdByParkIdPID(parkId, pId);
    }

    public Integer checkOpenPushAccount(Long parkId, String serviceName) {
        return this.thirdParkDao.checkOpenPushAccount(parkId, serviceName);
    }

    public ThirdInfo getThirdFeeUrl(Long parkId) {
        return this.getThirdConfig(parkId, this.THIRD_FEE);
    }

    public ThirdInfo getThirdQrUrl(Long parkId) {
        return this.getThirdConfig(parkId, this.THIRD_QR);
    }

    public ThirdInfo getThirdAdvice(Long parkId) {
        ThirdInfo thirdInfoFind = null;
        List<ThirdInfo> thirdInfoList = this.thirdParkDao.selectThirdByParkId(parkId);
        log.info("[\u83b7\u53d6\u4e09\u65b9\u914d\u7f6e]  [{}]", thirdInfoList);
        if (Objects.nonNull(thirdInfoList)) {
            for (ThirdInfo thirdInfo : thirdInfoList) {
                if (!this.isSuccess.equals(thirdInfo.getIsThirdAdvice())) continue;
                thirdInfoFind = thirdInfo;
                break;
            }
        }
        return thirdInfoFind;
    }

    public Boolean updateParams(String params, Integer id) {
        return this.thirdInfoDao.updateParamsById(params, id) > 0;
    }

    public Boolean addPushExtend(PushExtend pushExtend) {
        return this.pushExtendService.save(pushExtend);
    }

    public Boolean deletePushExtendById(Long id) {
        return this.pushExtendService.removeById(id);
    }

    public PushExtend getPushExtend(Long parkId, String plateNum, Long enterTime) {
        return (PushExtend)this.pushExtendService.selectLimitOne(PushExtend.builder().parkId(parkId).plateNum(plateNum).enterTime(enterTime).build());
    }

    public Integer addThirdInfo(ThirdInfo thirdInfo) {
        return this.thirdInfoDao.insert(thirdInfo);
    }

    private ThirdInfo getThirdConfig(Long parkId, Integer type) {
        ThirdInfo thirdInfoFind = null;
        List<ThirdInfo> thirdInfoList = this.thirdParkDao.selectThirdByParkId(parkId);
        if (Objects.nonNull(thirdInfoList)) {
            for (ThirdInfo thirdInfo : thirdInfoList) {
                if (this.THIRD_FEE.equals(type) && this.isSuccess.equals(thirdInfo.getIsThirdFee())) {
                    thirdInfoFind = thirdInfo;
                    break;
                }
                if (!this.THIRD_QR.equals(type) || !this.isSuccess.equals(thirdInfo.getIsThirdPay())) continue;
                thirdInfoFind = thirdInfo;
                break;
            }
        }
        return thirdInfoFind;
    }

    public ThirdParkMessage getThirdParkMessageBy(Long parkId) {
        ThirdParkRef thirdParkRef = (ThirdParkRef)this.thirdParkRefService.selectLimitOne((Object)ThirdParkRef.builder().parkId(parkId).build());
        if (thirdParkRef == null) {
            return null;
        }
        return ThirdParkMessage.builder().thirdParkId(thirdParkRef.getThirdParkId()).appId(this.appId).build();
    }

    public ObjectResponse<List<ThirdAttribute>> getThirdAttribute(Long thirdId) {
        List attributes = this.thirdAttributeService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ThirdAttribute.class).eq(ThirdAttribute::getThirdId, (Object)thirdId)).eq(ThirdAttribute::getDeleted, (Object)0)).orderByAsc(ThirdAttribute::getSortNum));
        return CollectionUtils.isEmpty((Collection)attributes) ? ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404) : ObjectResponse.success((Object)attributes);
    }

    public ObjectResponse<ThirdParam> getParkThirdParam(Long parkId, Long thirdId) {
        ThirdParam thirdParam = (ThirdParam)this.thirdParamService.selectLimitOne((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ThirdParam.class).eq(ThirdParam::getParkId, (Object)parkId)).eq(ThirdParam::getThirdId, (Object)thirdId)).eq(ThirdParam::getDeleted, (Object)0));
        if (thirdParam == null) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success((Object)thirdParam);
    }

    public ObjectResponse<ThirdParam> addParkThirdParam(ThirdParam params) {
        return this.thirdParamService.save((Object)params) ? ObjectResponse.success((Object)params) : ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
    }

    public ObjectResponse<ThirdParam> getPakThirdParamBy(Long id) {
        ThirdParam thirdParam = (ThirdParam)this.thirdParamService.selectLimitOne((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ThirdParam.class).eq(ThirdParam::getId, (Object)id)).eq(ThirdParam::getDeleted, (Object)0));
        if (thirdParam == null) {
            return ObjectResponse.failed();
        }
        return ObjectResponse.success((Object)thirdParam);
    }

    public ObjectResponse<ThirdParam> updateParkThirdParams(ThirdParam thirdParam) {
        return this.thirdParamService.updateById((Object)thirdParam) ? ObjectResponse.success((Object)thirdParam) : ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
    }

    public ObjectResponse<Page<ThirdParam>> getThirdParkPage(Long thirdId, Integer pageNo, Integer pageSize, Long parkId) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
        page.setCurrent((long)pageNo.intValue());
        page.setSize((long)pageSize.intValue());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(ThirdParam.class);
        queryWrapper.eq(ThirdParam::getThirdId, (Object)thirdId);
        if (Objects.nonNull(parkId)) {
            queryWrapper.eq(ThirdParam::getParkId, (Object)parkId);
        }
        queryWrapper.orderByDesc(ThirdParam::getUpdateTime);
        IPage result = this.thirdParamService.page((IPage)page, (Wrapper)queryWrapper);
        return ObjectResponse.success((Object)Page.instance((int)Math.toIntExact(result.getPages()), (long)result.getTotal(), (List)result.getRecords()));
    }

    public ObjectResponse<List<ThirdParam>> getThirdParamsByThirdId(Long thirdId) {
        List params = this.thirdParamService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ThirdParam.class).eq(ThirdParam::getThirdId, (Object)thirdId)).eq(ThirdParam::getDeleted, (Object)0));
        return CollectionUtils.isEmpty((Collection)params) ? ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404) : ObjectResponse.success((Object)params);
    }

    public ObjectResponse<Void> addThirdBstPark(ThirdBstPark thirdBstPark) {
        this.thirdBstParkService.addThirdBstPark(thirdBstPark);
        return ObjectResponse.success();
    }

    public ObjectResponse<Void> batchSaveBstParkSpace(List<BstAdSpace> bstAdSpaces) {
        this.bstAdSpaceService.saveBatch(bstAdSpaces);
        return ObjectResponse.success();
    }

    public ObjectResponse<BstAdSpace> getBstAdSpace(String parkCode, Integer deviceType, Integer triggerEvent) {
        String cacheKey = BST_SPACE_KEY + parkCode + ":" + deviceType + ":" + triggerEvent;
        BstAdSpace bstAdSpace = (BstAdSpace)this.redisHandle.cacheObject(cacheKey, BstAdSpace.class, () -> (BstAdSpace)this.bstAdSpaceService.selectLimitOne(BstAdSpace.builder().parkCode(parkCode).deviceType(deviceType).triggerEvent(triggerEvent).build()), 86400000L);
        if (bstAdSpace == null) {
            return ObjectResponse.failed((String)"404");
        }
        return ObjectResponse.success((Object)bstAdSpace);
    }

    public ObjectResponse<ThirdTongchengPark> selectTongchengPark(String parkNo) {
        ThirdTongchengPark tongchengPark = this.thirdTongchengParkService.getThirdTongchengParkByThirdIdAndParkNo(parkNo);
        if (Objects.nonNull(tongchengPark)) {
            return ObjectResponse.success((Object)tongchengPark);
        }
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
    }

    public ObjectResponse<ThirdTongchengPark> selectTongchengParkCode(String parkCode) {
        ThirdTongchengPark tongchengPark = this.thirdTongchengParkService.getThirdTongchengParkByThirdIdAndParkCode(parkCode);
        if (Objects.nonNull(tongchengPark)) {
            return ObjectResponse.success((Object)tongchengPark);
        }
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
    }

    public ObjectResponse<ThirdInfo> selectThirdByTongchengPark(String parkNo) {
        ThirdTongchengPark tongchengPark = this.thirdTongchengParkService.getThirdTongchengParkByThirdIdAndParkNo(parkNo);
        if (Objects.isNull(tongchengPark)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        ThirdInfo thirdInfo = new ThirdInfo();
        thirdInfo.setId(tongchengPark.getThirdId());
        thirdInfo = (ThirdInfo)this.thirdInfoDao.selectById(thirdInfo);
        if (Objects.nonNull(thirdInfo)) {
            return ObjectResponse.success((Object)thirdInfo);
        }
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
    }

    public ObjectResponse<ThirdTongchengParkChannel> selectTongchengParkChannel(String parkNo, String chNo) {
        ThirdTongchengPark tongchengPark;
        ThirdTongchengParkChannel thirdTongchengParkChannel;
        ObjectResponse<ThirdTongchengPark> thirdTongchengParkObjectResponse = this.selectTongchengPark(parkNo);
        if (ObjectResponse.isSuccess(thirdTongchengParkObjectResponse) && Objects.nonNull(thirdTongchengParkChannel = this.tongchengParkChannelService.getThirdTongchengParkChannelByChNo((tongchengPark = (ThirdTongchengPark)thirdTongchengParkObjectResponse.getData()).getId(), chNo))) {
            return ObjectResponse.success((Object)thirdTongchengParkChannel);
        }
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
    }

    public ObjectResponse<ThirdTongchengParkChannel> selectTongchengParkCodeChannel(String parkCode, String channelCode) {
        ThirdTongchengPark tongchengPark;
        ThirdTongchengParkChannel thirdTongchengParkChannel;
        ObjectResponse<ThirdTongchengPark> thirdTongchengParkObjectResponse = this.selectTongchengParkCode(parkCode);
        if (ObjectResponse.isSuccess(thirdTongchengParkObjectResponse) && Objects.nonNull(thirdTongchengParkChannel = this.tongchengParkChannelService.getThirdTongchengParkChannelByChannelCode((tongchengPark = (ThirdTongchengPark)thirdTongchengParkObjectResponse.getData()).getId(), channelCode))) {
            return ObjectResponse.success((Object)thirdTongchengParkChannel);
        }
        return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
    }

    public ThirdInfo selectHaiDaChuanXIng(Long parkId) {
        ThirdInfo thirdInfo = this.thirdParkDao.selectThirdByParkIdPID(parkId, "ACCESS_POWER");
        return thirdInfo;
    }

    public ThirdInfo selectHaiDaJituan(Long parkId) {
        ThirdInfo thirdInfo = this.thirdParkDao.selectThirdByParkIdUrl(parkId, "HAIDA_MORECARD");
        return thirdInfo;
    }

    public ObjectResponse<ThirdInfo> getThirdInfoBy(String pid, Long parkId) {
        ThirdInfo thirdInfo = this.thirdInfoDao.selectThirdInfoBy(pid, parkId);
        return thirdInfo == null ? ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404) : ObjectResponse.success((Object)thirdInfo);
    }
}

