/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.third.service.third;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.icetech.cloudcenter.api.third.PushRecordService;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.third.dao.third.PushRecordDao;
import com.icetech.third.domain.entity.third.PushRecord;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="pushRecordService")
public class PushRecordServiceImpl
extends ServiceImpl<PushRecordDao, PushRecord>
implements PushRecordService {
    private static final Logger log = LoggerFactory.getLogger(PushRecordServiceImpl.class);
    @Resource
    private PushRecordDao pushRecordDao;

    public ObjectResponse<PushRecord> getRecordByMsg(String msgId, String group) {
        PushRecord record = (PushRecord)this.pushRecordDao.selectLimitOne((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(PushRecord.class).eq(PushRecord::getMsgId, (Object)msgId)).eq(PushRecord::getPushGroup, (Object)group));
        return ObjectResponse.returnNotFoundIfNull((Object)record);
    }

    public ObjectResponse<PushRecord> addRecord(PushRecord pushRecord) {
        int result;
        if (StringUtils.length((CharSequence)pushRecord.getRemark()) > 200) {
            pushRecord.setRemark(pushRecord.getRemark().substring(0, 200));
        }
        return (result = this.pushRecordDao.insert(pushRecord)) == 1 ? ObjectResponse.success((Object)pushRecord) : ObjectResponse.failed((String)"500");
    }

    public ObjectResponse<Integer> insertRecord(PushRecord pushRecord) {
        int result = this.pushRecordDao.insert(pushRecord);
        if (StringUtils.length((CharSequence)pushRecord.getRemark()) > 200) {
            pushRecord.setRemark(pushRecord.getRemark().substring(0, 200));
        }
        return ObjectResponse.success((Object)result);
    }

    public ObjectResponse<Integer> updateRecordById(PushRecord pushRecord) {
        pushRecord.setUpdateTime(new Date());
        int result = this.pushRecordDao.updateById(pushRecord);
        if (StringUtils.length((CharSequence)pushRecord.getRemark()) > 200) {
            pushRecord.setRemark(pushRecord.getRemark().substring(0, 200));
        }
        return ObjectResponse.success((Object)result);
    }

    public ObjectResponse<Integer> addOrUpdateById(PushRecord pushRecord) {
        if (StringUtils.length((CharSequence)pushRecord.getRemark()) > 200) {
            pushRecord.setRemark(pushRecord.getRemark().substring(0, 200));
        }
        int result = 0;
        if (pushRecord.getId() == null) {
            result = this.pushRecordDao.insert(pushRecord);
        } else {
            pushRecord.setUpdateTime(new Date());
            result = this.pushRecordDao.updateById(pushRecord);
        }
        return ObjectResponse.success((Object)result);
    }

    public ObjectResponse<Integer> deleteById(long id) {
        int result = this.pushRecordDao.deleteById(Long.valueOf(id));
        return ObjectResponse.success((Object)result);
    }
}

