/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.third.config.prop;

import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(value="ice.dtn.push")
public class DtnPushProp {
    protected boolean enabled = false;
    protected Set<Long> includeParkIds = new HashSet<Long>();

    public boolean isPush(Long parkId) {
        return this.enabled && parkId != null && this.includeParkIds.contains(parkId);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Set<Long> getIncludeParkIds() {
        return this.includeParkIds;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setIncludeParkIds(Set<Long> includeParkIds) {
        this.includeParkIds = includeParkIds;
    }

    public String toString() {
        return "DtnPushProp(enabled=" + this.isEnabled() + ", includeParkIds=" + this.getIncludeParkIds() + ")";
    }
}

