/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.third.aop;

import com.icetech.third.anno.AsyncMethod;
import java.util.concurrent.ThreadPoolExecutor;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Order(value=-2147483648)
@Component
public class AsyncMethodAop {
    private static final Logger log = LoggerFactory.getLogger(AsyncMethodAop.class);
    @Autowired
    private ThreadPoolExecutor asyncMethodExecutor;

    @Pointcut(value="@annotation(com.icetech.third.anno.AsyncMethod)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object async(ProceedingJoinPoint point) throws Throwable {
        MethodSignature methodSignature;
        Signature signature = point.getSignature();
        if (signature instanceof MethodSignature) {
            methodSignature = (MethodSignature)signature;
            AsyncMethod asyncMethod = methodSignature.getMethod().getAnnotation(AsyncMethod.class);
            if (asyncMethod == null || !asyncMethod.async()) {
                return point.proceed(point.getArgs());
            }
        } else {
            throw new UnsupportedOperationException();
        }
        log.info("\u5f02\u6b65\u6267\u884c[{}.{}]\u5f00\u59cb", (Object)point.getTarget().getClass().getName(), (Object)methodSignature.getMethod().getName());
        this.asyncMethodExecutor.execute(() -> {
            try {
                Object result = point.proceed(point.getArgs());
                log.info("\u5f02\u6b65\u6267\u884c[{}.{}]\u6210\u529f: {}", new Object[]{point.getTarget().getClass().getName(), methodSignature.getMethod().getName(), result});
            }
            catch (Throwable e) {
                log.error("\u5f02\u6b65\u6267\u884c[{}.{}]\u51fa\u9519", new Object[]{point.getTarget().getClass().getName(), methodSignature.getMethod().getName(), e});
            }
        });
        return null;
    }
}

