package com.icetech.third.domain.enums;

import lombok.Getter;

public enum PushServiceEnum {

    入场推送("enter",14, "p2c.enter.msg"),
    出场推送("exit",15, "p2c.exit.msg"),
    推送车场("sendPark",1001, "p2c.send.park.msg"),
    支付推送("pay",1, "p2c.pay.msg"),
    设备状态变化("deviceStatusInfo",16, "p2c.device.status.msg"),
    开关闸报警("warningMsgInfo",17, "p2c.warning.msg.info"),
    三方计费("thirdFee",18, "p2c.query.third.fee"),
    对讲柱支付码("itcPayCode",19, "itc.pay.code.msg"),
    空车位数推送("sendFreeSpace",1002, "p2c.send.freespace.msg"),
    出场识别("exitIdentify",20, "p2c.exit.identify.msg"),
    ;

    @Getter
    private final String serviceName;
    @Getter
    private final Integer serviceType;

    @Getter
    private final String method;

    private PushServiceEnum(String serviceName, Integer serviceType, String method) {
        this.serviceName = serviceName;
        this.serviceType = serviceType;
        this.method = method;
    }

    public static String getServiceName(Integer serviceType) {
        for (PushServiceEnum p : PushServiceEnum.values()) {
            if (serviceType.equals(p.getServiceType())) {
                return p.serviceName;
            }
        }
        return null;
    }

    public static Integer getServiceType(String serviceName) {
        for (PushServiceEnum p : PushServiceEnum.values()) {
            if (serviceName.equals(p.getServiceName())) {
                return p.serviceType;
            }
        }
        return null;
    }

    public static String getMethod(Integer serviceType) {
        for (PushServiceEnum p : PushServiceEnum.values()) {
            if (serviceType.equals(p.getServiceType())) {
                return p.method;
            }
        }
        return null;
    }
}
