package com.icetech.third.domain.entity.third;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 同城支付第三方车场配置
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2024-06-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_third_tongcheng_park")
public class ThirdTongchengPark implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 三方机构id
     */
    private Integer thirdId;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 车场编码
     */
    private String parkCode;

    /**
     * 第三方车场编码
     */
    private String thirdParkNo;

    /**
     * 状态 1=启用 0=删除
     */
    private Integer state;

    /**
     * 包含第三方二维码信息等
     */
    private String ext;

    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
