package com.icetech.third.domain.entity.third;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
@TableName(value = "`ice_third_teld_account`")
public class ThirdTeldAccount implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "`id`")
    protected Long id;
    /**
     * 运营商标识
     */
    @TableField(value = "`operator_id`")
    protected String operatorId;
    /**
     * 运营商密钥
     */
    @TableField(value = "`operator_secret`")
    protected String operatorSecret;
    /**
     * 签名密钥
     */
    @TableField(value = "`sign_key`")
    protected String signKey;
    /**
     * AES加密密钥
     */
    @TableField(value = "`aes_key`")
    protected String aesKey;
    /**
     * AES加密向量
     */
    @TableField(value = "`aes_spec`")
    protected String aesSpec;
    /**
     * 创建时间
     */
    @TableField(value = "`create_time`")
    protected Date createTime;

/*
DROP TABLE IF EXISTS `ice_cloudpark`.`ice_third_teld_account`;
CREATE TABLE `ice_cloudpark`.`ice_third_teld_account` (
 `id` INT(11) PRIMARY KEY AUTO_INCREMENT COMMENT '主键ID',
 `operator_id` VARCHAR(32) NOT NULL COMMENT '运营商标识',
 `operator_secret` VARCHAR(64) NOT NULL COMMENT '运营商密钥',
 `sign_key` VARCHAR(64) NOT NULL COMMENT '签名密钥',
 `aes_key` VARCHAR(64) NOT NULL COMMENT 'AES加密密钥',
 `aes_spec` VARCHAR(64) NOT NULL COMMENT 'AES加密向量',
 `create_time` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
 UNIQUE INDEX `idx_operator_id` (operator_id)
) COMMENT '特来电账户配置';
 */
}
