package com.icetech.third.domain.entity.third;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 泊斯特车场
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2023-06-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_third_bst_park")
@AllArgsConstructor
@Builder
public class ThirdBstPark implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 停车场ID
     */
    private Integer parkId;

    /**
     * 停车场编号
     */
    private String parkCode;

    /**
     * 分配的车场账户Id
     */
    private String accountId;

    /**
     * 分配的车场账户秘钥
     */
    private String secret;

    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
