package com.icetech.third.domain.entity.third;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
@TableName(value = "`ice_third_teld_record`")
public class ThirdTeldRecord implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "`id`")
    protected Long id;
    /**
     * 停车场ID
     */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /**
     * 停车场编号
     */
    @TableField(value = "`park_code`")
    protected String parkCode;
    /**
     * 云平台订单号
     */
    @TableField(value = "`order_num`")
    protected String orderNum;
    /**
     * 云平台优惠券ID
     */
    @TableField(value = "`discount_id`")
    protected Long discountId;
    /**
     * 充电订单号: 充电运营商订单号，即停车票编号，特来电的格式：8位日期+10位序列号
     */
    @TableField(value = "`start_charge_seq`")
    protected String startChargeSeq;
    /**
     * 电站编号: 充电运营商定义的电站唯一编码
     */
    @TableField(value = "`station_id`")
    protected String stationId;
    /**
     * 电站名称: 充电站名称的描述
     */
    @TableField(value = "`station_name`")
    protected String stationName;
    /**
     * 充电设备接口编码: 充电运营商充电设备接口的编码
     */
    @TableField(value = "`connector_id`")
    protected String connectorId;
    /**
     * 充电设备接口名称: 充电设备的名称，同一场站下唯一，如“301号交流”
     */
    @TableField(value = "`connector_name`")
    protected String connectorName;
    /**
     * 车牌号: 必填项，需兼容新能源车牌号
     */
    @TableField(value = "`plate_num`")
    protected String plateNum;
    /**
     * 车位号: 车位号
     */
    @TableField(value = "`park_no`")
    protected String parkNo;
    /**
     * 开始充电时间: 格式“yyyy-MM-dd HH:mm:ss”
     */
    @TableField(value = "`start_time`")
    protected Date startTime;
    /**
     * 结束充电时间: 格式“yyyy-MM-dd HH:mm:ss”，充电结束之前为空
     */
    @TableField(value = "`end_time`")
    protected Date endTime;
    /**
     * 充电量: 单位：度，小数点后2位，充电结束之前为空
     */
    @TableField(value = "`power`")
    protected Double power;
    /**
     * 电费: 单位：元，小数点后2位，充电结束之前为空
     */
    @TableField(value = "`elec_money`")
    protected Double elecMoney;
    /**
     * 服务费: 单位：元，小数点后2位，充电结束之前为空
     */
    @TableField(value = "`sevice_money`")
    protected Double seviceMoney;
    /**
     * 总金额: 单位：元，小数点后2位，充电结束之前为空
     */
    @TableField(value = "`total_money`")
    protected Double totalMoney;
    /**
     * 停车减免方式: 减免停车费的计算方式：1：根据时长减免、2：根据费用减免、3：停车场决定
     */
    @TableField(value = "`calculation_method`")
    protected Integer calculationMethod;
    /**
     * 停车减免时长: 单位：分钟
     */
    @TableField(value = "`free_parking_times`")
    protected Integer freeParkingTimes;
    /**
     * 停车减免费用: 单位：元
     */
    @TableField(value = "`free_parking_cost`")
    protected Double freeParkingCost;
    /**
     * 停车票更新时间: 格式“yyyy-MM-dd HH:mm:ss”
     */
    @TableField(value = "`last_update_time`")
    protected Date lastUpdateTime;
    /**
     * 车牌鉴权结果: 0：未鉴权、1：鉴权通过、2：鉴权不通过
     */
    @TableField(value = "`plate_aut_result`")
    protected Integer plateAutResult;
    /**
     * 鉴权失败原因: 鉴权失败原因，返回如下错误码：0:无（鉴权通过或未鉴权）;1:车辆不在停车场;2:无该停车场权限;3:停车场标识不正确;4:优惠券已下发，请勿重复下发;5:优惠券生成失败;6:优惠券已用完;7:参数异常;8:请勿在短时间内频繁操作;9:服务器内部异常;10:未知
     */
    @TableField(value = "`plate_aut_fail_reason`")
    protected Integer plateAutFailReason;
    /**
     * 出场时间: 车辆离开停车场时间，式“yyyy-MM-dd HH:mm:ss”
     */
    @TableField(value = "`leaving_time`")
    protected Date leavingTime;
    /**
     * 实际停车减免金额: 停车减免金额，单位为元
     */
    @TableField(value = "`park_free_amount`")
    protected Double parkFreeAmount;
    /**
     * 实际停车减免时长: 停车减免时长，单位为分钟
     */
    @TableField(value = "`park_free_time`")
    protected Integer parkFreeTime;
    /**
     * 消费通知成功状态
     */
    @TableField(value = "`consume_succ_stat`")
    protected Integer consumeSuccStat;
    /**
     * 消费通知失败原因
     */
    @TableField(value = "`consume_fail_reason`")
    protected Integer consumeFailReason;
    /**
     * 创建时间
     */
    @TableField(value = "`create_time`")
    protected Date createTime;
    /**
     * 创建时间
     */
    @TableField(value = "`update_time`", updateStrategy = FieldStrategy.NEVER)
    protected Date updateTime;
}
