package com.icetech.third.domain.entity.third;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;

import lombok.*;

/**
 * 三方推送扩展信息表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2022-01-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_push_extend")
@Builder
@AllArgsConstructor
public class PushExtend implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * id主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 车场编码
     */
    private String parkCode;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 入场时间
     */
    private Long enterTime;

    /**
     * 入场记录id
     */
    private String recordId;

    /**
     * 扩展参数
     */
    private String param;

    /**
     * 创建时间
     */
    private Date createdTime;

    /**
     * 更新时间
     */
    private Date updatedTime;

    /**
     * 删除标志:0未删除;1已删除
     */
    private Boolean deleted;


}
