package com.icetech.third.domain.entity.third;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 泊斯特广告位
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2023-06-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_bst_ad_space")
@AllArgsConstructor
@Builder
public class BstAdSpace implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 停车场ID
     */
    private Integer parkId;

    /**
     * 停车场编号
     */
    private String parkCode;

    /**
     * 设备类型 0：公众号；1：小程序； 2：APP；3：缴费机 4：补交机 ；5;电视机；6：支付宝；9;通用设备
     */
    private Integer deviceType;

    /**
     * 触发事件。 0:车牌查询页（输入车牌页面）；1:支付完成页（支付完毕）；2:入场消息推送页；3:出场消息推送页；4:优惠活动广告页； 5:首页广告；6:支付确认（付款前）;7：启动页；8：支付完成通知；9:弹出式广告页面;10:口令广告;15：一般页面广告;16:公众号菜单栏;17:线下二维码;32:其他页
     */
    private Integer triggerEvent;


    /**
     * 广告位编号。流量主内部的广告位Id(双方核对数据时用)
     */
    private String spaceNumber;

    /**
     * 广告位名称
     */
    private String spaceName;

    /**
     * 分配的广告位账户Id。通过该账号可以编程来获取可播放的广告,即访问api/ad/bid接口
     */
    private String accountId;

    /**
     * 分配的广告位秘钥
     */
    private String secret;

    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
