/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.report.service.impl;

import com.icetech.cloudcenter.api.report.ParkAdvertIncomeService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.report.dao.ParkAdvertIncomeMapper;
import com.icetech.report.domain.entity.ParkAdvertIncome;
import com.icetech.report.domain.vo.AdvertReportVo;
import com.icetech.report.domain.vo.AdvertVo;
import com.icetech.third.anno.DS_SLAVE;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ParkAdvertIncomeServiceImpl
extends BaseServiceImpl<ParkAdvertIncomeMapper, ParkAdvertIncome>
implements ParkAdvertIncomeService {
    @Autowired
    private ParkAdvertIncomeMapper parkAdvertIncomeMapper;

    public ParkAdvertIncome getParkAdvertIncomeById(Long id) {
        return (ParkAdvertIncome)this.getById(id);
    }

    public Boolean addParkAdvertIncome(ParkAdvertIncome entity) {
        return this.save(entity);
    }

    public Boolean modifyParkAdvertIncome(ParkAdvertIncome entity) {
        return this.updateById(entity);
    }

    public Boolean removeParkAdvertIncomeById(Long id) {
        return this.removeById(id);
    }

    public List<AdvertVo> getAdvertIncome(Long reportDate) {
        return this.parkAdvertIncomeMapper.selectAdvertIncome(reportDate);
    }

    @DS_SLAVE
    public List<AdvertReportVo> getReportYear(Integer year) {
        return this.parkAdvertIncomeMapper.selectReportYear(year);
    }

    public List<AdvertReportVo> getReportMonth(Integer month) {
        return this.parkAdvertIncomeMapper.selectReportMonth(month);
    }

    @DS_SLAVE
    public BigDecimal getSumAmount(int year) {
        return this.parkAdvertIncomeMapper.selectSumAmountBy(year);
    }
}

