package com.icetech.report.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.api.report.TempCarStatisticsService;
import com.icetech.report.dao.TempCarStatisticsMapper;
import com.icetech.report.domain.entity.TempCarStatistics;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 临时车日统计表 服务实现类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-10-09
 */
@Service
public class TempCarStatisticsServiceImpl extends BaseServiceImpl<TempCarStatisticsMapper, TempCarStatistics> implements TempCarStatisticsService {

    /**
     * Description: 根据ID查询 临时车日统计表对象信息 <br>
     * Version1.0 2021-10-09 by wanggang创建
     *
     * @param id 对象id
     * @return TempCarStatistics
     */
    @Override
    public TempCarStatistics getTempCarStatisticsById(Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  临时车日统计表对象信息 <br>
     * Version1.0 2021-10-09 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addTempCarStatistics(TempCarStatistics entity) {
        return save(entity);
    }

    /**
     * Description: 修改 临时车日统计表对象信息 <br>
     * Version1.0 2021-10-09 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyTempCarStatistics(TempCarStatistics entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  临时车日统计表对象信息 <br>
     * Version1.0 2021-10-09 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeTempCarStatisticsById(Long id) {
        return removeById(id);
    }

    @Override
    public List<TempCarStatistics> getCarReportList(Long parkId, String startTime, String endTime) {
        return list(Wrappers.lambdaQuery(TempCarStatistics.class)
                .eq(TempCarStatistics::getParkId, parkId)
                .ge(TempCarStatistics::getPayDate, startTime)
                .le(TempCarStatistics::getPayDate, endTime)
        );
    }

}
