package com.icetech.report.service.impl;

import com.icetech.cloudcenter.api.report.PaymentRebateDayReportService;
import com.icetech.report.dao.PaymentRebateDayReportMapper;
import com.icetech.report.domain.entity.PaymentRebateDayReport;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.report.domain.vo.IncomeVo;
import com.icetech.report.domain.vo.RebateVo;
import com.icetech.third.anno.DS_SLAVE;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

/**
 * 支付返利日结表 服务实现类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2023-10-23
 */
@Service
public class PaymentRebateDayReportServiceImpl extends BaseServiceImpl<PaymentRebateDayReportMapper, PaymentRebateDayReport> implements PaymentRebateDayReportService {

    @Autowired
    private PaymentRebateDayReportMapper paymentRebateDayReportMapper;

    /**
     * Description: 根据ID查询 支付返利日结表对象信息 <br>
     * Version1.0 2023-10-23 by wanggang创建
     *
     * @param id 对象id
     * @return PaymentRebateDayReport
     */
    @Override
    public PaymentRebateDayReport getPaymentRebateDayReportById(Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  支付返利日结表对象信息 <br>
     * Version1.0 2023-10-23 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addPaymentRebateDayReport(PaymentRebateDayReport entity) {
        return save(entity);
    }

    /**
     * Description: 修改 支付返利日结表对象信息 <br>
     * Version1.0 2023-10-23 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyPaymentRebateDayReport(PaymentRebateDayReport entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  支付返利日结表对象信息 <br>
     * Version1.0 2023-10-23 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removePaymentRebateDayReportById(Long id) {
        return removeById(id);
    }

    @Override
    public List<RebateVo> getYesterdayPayRebate(Long reportDay) {
        return paymentRebateDayReportMapper.selectYesterdayPayRebate(reportDay);
    }

    @Override
    @DS_SLAVE
    public BigDecimal getYearSumRebate(int year) {
        return paymentRebateDayReportMapper.selectYearSumRebate(year);
    }

    @Override
    @DS_SLAVE
    public List<IncomeVo> getRebateYearData(Integer year) {
        return paymentRebateDayReportMapper.selectRebateYearData(year);
    }

    @Override
    @DS_SLAVE
    public List<IncomeVo> getRebateMonthData(Integer yearAndMonth) {
        return paymentRebateDayReportMapper.selectRebateMonthData(yearAndMonth);
    }

}
