package com.icetech.report.service.impl;

import com.icetech.cloudcenter.api.report.ParkReportStaticsService;
import com.icetech.report.dao.ParkReportStaticsMapper;
import com.icetech.report.domain.entity.ParkReportStatics;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.report.domain.vo.ElectronAmountPayNumVo;
import com.icetech.report.domain.vo.ParkChannelReportVo;
import com.icetech.report.domain.vo.ParkChannelStatisticsVo;
import com.icetech.report.domain.vo.ParkPayReportVo;
import com.icetech.third.anno.DS_SLAVE;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

/**
 * 车场统计营分析报表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2023-10-17
 */
@Service
public class ParkReportStaticsServiceImpl extends BaseServiceImpl<ParkReportStaticsMapper, ParkReportStatics> implements ParkReportStaticsService {

    @Autowired
    private ParkReportStaticsMapper parkReportStaticsMapper;

    /**
     * Description: 根据ID查询 车场统计营分析报表对象信息 <br>
     * Version1.0 2023-10-17 by wanggang创建
     *
     * @param id 对象id
     * @return ParkReportStatics
     */
    @Override
    public ParkReportStatics getParkReportStaticsById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  车场统计营分析报表对象信息 <br>
     * Version1.0 2023-10-17 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addParkReportStatics (ParkReportStatics entity) {
        return save(entity);
    }

    /**
     * Description: 修改 车场统计营分析报表对象信息 <br>
     * Version1.0 2023-10-17 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyParkReportStatics (ParkReportStatics entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  车场统计营分析报表对象信息 <br>
     * Version1.0 2023-10-17 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeParkReportStaticsById (Long id) {
        return removeById(id);
    }

    @Override
    public ParkChannelStatisticsVo getParkChannelsStatistics(Long reportDate) {
       return parkReportStaticsMapper.selectParkChannelsStatistics(reportDate);
    }

    @Override
    public BigDecimal getTotalPayAmount(Long reportDate) {
        return parkReportStaticsMapper.selectTotalPayAmount(reportDate);
    }

    @Override
    public ElectronAmountPayNumVo getElectronAmountPayNum(Long reportDate) {
        return parkReportStaticsMapper.selectElectronAmountPayNum(reportDate);
    }

    @Override
    public List<ParkPayReportVo> getParkPayMonth(Integer month) {
        return parkReportStaticsMapper.selectParkPayMonth(month);
    }

    @Override
    public List<ParkPayReportVo> getParkPayYear(Integer year) {
        return parkReportStaticsMapper.selectParkPayYear(year);
    }

    @Override
    @DS_SLAVE
    public List<ParkChannelReportVo> getParkNumsYearList(String startTime, String endTime) {
        return parkReportStaticsMapper.selectParkNumsYearList(startTime, endTime);
    }

    @Override
    @DS_SLAVE
    public List<ParkChannelReportVo> getParkNumsMonthList(String startTime, String endTime) {
        return parkReportStaticsMapper.selectParkNumsMonthList(startTime, endTime);
    }

}
