package com.icetech.report.service.impl;

import com.icetech.cloudcenter.api.report.CarTimeStatisticsService;
import com.icetech.report.dao.CarTimeStatisticsMapper;
import com.icetech.report.domain.entity.CarTimeStatistics;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 停车时长日统计表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-10-10
 */
@Service
public class CarTimeStatisticsServiceImpl extends BaseServiceImpl<CarTimeStatisticsMapper, CarTimeStatistics> implements CarTimeStatisticsService {

    /**
     * Description: 根据ID查询 停车时长日统计表对象信息 <br>
     * Version1.0 2021-10-10 by wanggang创建
     *
     * @param id 对象id
     * @return CarTimeStatistics
     */
    @Override
    public CarTimeStatistics getCarTimeStatisticsById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  停车时长日统计表对象信息 <br>
     * Version1.0 2021-10-10 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addCarTimeStatistics (CarTimeStatistics entity) {
        return save(entity);
    }

    /**
     * Description: 修改 停车时长日统计表对象信息 <br>
     * Version1.0 2021-10-10 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyCarTimeStatistics (CarTimeStatistics entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  停车时长日统计表对象信息 <br>
     * Version1.0 2021-10-10 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeCarTimeStatisticsById (Long id) {
        return removeById(id);
    }

}
