package com.icetech.report.service.impl;

import com.icetech.cloudcenter.api.report.CarReportService;
import com.icetech.cloudcenter.api.report.TempCarReportService;
import com.icetech.cloudcenter.api.report.TempCarStatisticsService;
import com.icetech.report.domain.entity.TempCarReport;
import com.icetech.report.domain.entity.TempCarStatistics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * @author wanggang
 * @create 2021-09-09 10:58
 */
@Service("carReportService")
public class CarReportServiceImpl implements CarReportService {

    @Autowired
    private TempCarReportService tempCarReportService;

    @Autowired
    private TempCarStatisticsService tempCarStatisticsService;

    @Override
    public List<TempCarReport> getList(Integer parkId, Date startTime, Date endTime) {
        return tempCarReportService.getCarReportList(parkId, startTime, endTime);
    }

    @Override
    public List<TempCarStatistics> getTempCarStatisticsList(Long parkId, String startTime, String endTime) {
        return tempCarStatisticsService.getCarReportList(parkId, startTime, endTime);
    }
}
