package com.icetech.report.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.api.report.CarEnterExitTimeReportService;
import com.icetech.cloudcenter.api.report.CarEnterExitTimeService;
import com.icetech.cloudcenter.api.report.CarTimeStatisticsService;
import com.icetech.report.domain.entity.CarEnterExitTimeReport;
import com.icetech.report.domain.entity.CarTimeStatistics;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author wanggang
 * @create 2021-09-09 18:11
 */
@Service("carEnterExitTimeService")
@Slf4j
public class CarEnterExitTimeServiceImpl implements CarEnterExitTimeService {

    @Autowired
    private CarEnterExitTimeReportService carEnterExitTimeReportService;

    @Autowired
    private CarTimeStatisticsService carTimeStatisticsService;

    @Override
    public List<CarEnterExitTimeReport> getList(Integer parkId, Long startTime, Long endTime) {
        return carEnterExitTimeReportService.list(Wrappers.lambdaQuery(CarEnterExitTimeReport.class)
                .eq(CarEnterExitTimeReport::getParkId, parkId)
                .ge(CarEnterExitTimeReport::getEnterTime, startTime)
                .le(CarEnterExitTimeReport::getExitTime, endTime));
    }

    @Override
    public List<CarTimeStatistics> getCarTimeStatisticsList(Long parkId, String startTime, String endTime) {
        return carTimeStatisticsService.list(Wrappers.lambdaQuery(CarTimeStatistics.class)
                .eq(CarTimeStatistics::getParkId, parkId)
                .ge(CarTimeStatistics::getExitTime, startTime)
                .le(CarTimeStatistics::getExitTime, endTime)
        );
    }
}
