package com.icetech.report.dao;

import com.icetech.db.mybatis.base.mapper.SuperMapper;
import com.icetech.report.domain.entity.ParkAdvertIncome;
import com.icetech.report.domain.vo.AdvertReportVo;
import com.icetech.report.domain.vo.AdvertVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 车场广告收益表 Mapper 接口
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2023-10-18
 */
@Mapper
public interface ParkAdvertIncomeMapper extends SuperMapper<ParkAdvertIncome> {

    List<AdvertVo> selectAdvertIncome(@Param("reportDate") Long reportDate);

    List<AdvertReportVo> selectReportYear(@Param("year") Integer year);

    List<AdvertReportVo> selectReportMonth(@Param("month") Integer month);

    BigDecimal selectSumAmountBy(@Param("year") int year);

}