package com.icetech.report.service.screen.impl;

import com.icetech.report.dao.screen.ScreenMapper;
import com.icetech.report.domain.entity.screen.Screen;
import com.icetech.report.service.screen.ScreenService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 屏幕表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-08-06
 */
@Service
public class ScreenServiceImpl extends BaseServiceImpl<ScreenMapper, Screen> implements ScreenService {

    /**
     * Description: 根据ID查询 屏幕表对象信息 <br>
     * Version1.0 2021-08-06 by wanggang创建
     *
     * @param id 对象id
     * @return Screen
     */
    @Override
    public Screen getScreenById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  屏幕表对象信息 <br>
     * Version1.0 2021-08-06 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addScreen (Screen entity) {
        return save(entity);
    }

    /**
     * Description: 修改 屏幕表对象信息 <br>
     * Version1.0 2021-08-06 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyScreen (Screen entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  屏幕表对象信息 <br>
     * Version1.0 2021-08-06 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeScreenById (Long id) {
        return removeById(id);
    }

}
